﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/基本設定タブ/基本設定グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterBasicBasicData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterBasicBasicData() :
            base()
        {
            this.ParticleFollowType = 0;
            this.EnableGpuEmitter = 0;
            this.EnableEndProcess = true;
            this.EnableAlphaFade = false;
            this.AlphaFadeTime = 10;
        }

        /// <summary>
        /// パーティクル追従タイプです
        /// </summary>
        [DataModelPropertyGuid("ad1366d9-3dba-4cb4-a8ed-8987929b4b5f")]
        public int ParticleFollowType { get; set; }

        /// <summary>
        /// GPUエミッタの有効無効切り替えスイッチです。
        /// </summary>
        [DataModelPropertyGuid("4e81e16e-9a7c-40a3-acae-ea1826075646")]
        public int EnableGpuEmitter { get; set; }

        /// <summary>
        /// 終了処理を有効化するかどうかのフラグです。
        /// </summary>
        [DataModelPropertyGuid("5376956e-e460-47dd-b9df-a6d805397fbb")]
        public bool EnableEndProcess { get; set; }

        /// <summary>
        /// フェードタイプです。
        /// </summary>
        [DataModelPropertyGuid("b6d5c6b5-e628-4763-b68f-9130fbddcf37")]
        public bool EnableAlphaFade { get; set; }

        /// <summary>
        /// αフェード時間です。
        /// </summary>
        [DataModelPropertyGuid("bf9e6d74-7ef2-4bd6-91d0-9972a7abb46a")]
        public int AlphaFadeTime { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterBasicBasicData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ParticleFollowType = srcDataModel.ParticleFollowType;
            this.EnableGpuEmitter = srcDataModel.EnableGpuEmitter;
            this.EnableEndProcess = srcDataModel.EnableEndProcess;
            this.EnableAlphaFade = srcDataModel.EnableAlphaFade;
            this.AlphaFadeTime = srcDataModel.AlphaFadeTime;

            return true;
        }
    }
}
