﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタ時間アニメ共通のデータモデルです.
    /// </summary>
    [Serializable]
    public class EmitterAnimationCommonData : DataModelBase
    {
        /// <summary>
        /// アニメーションテーブル
        /// </summary>
        private AnimationTableData animationTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterAnimationCommonData() :
            base()
        {
            this.InterpolationMode = 0;
            this.LoopMode = 0;
        }

        /// <summary>
        /// アニメーションの有無
        /// </summary>
        [DataModelPropertyGuid("2502dfb1-1df2-419f-acf1-095e3a9abf13")]
        public bool EnableAnimation { get; set; }

        /// <summary>
        /// 補間タイプ
        /// </summary>
        [DataModelPropertyGuid("3a4aece1-b135-4509-ad42-fc8503a7c890")]
        public int InterpolationMode { get; set; }

        /// <summary>
        /// 再生タイプ
        /// </summary>
        [DataModelPropertyGuid("978261f5-5da3-4d3f-8c24-f39307f7d8e9")]
        public int LoopMode { get; set; }

        /// <summary>
        /// アニメーションテーブル
        /// </summary>
        [DataModelPropertyGuid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3")]
        public AnimationTableData AnimationTable
        {
            get { return this.GetObjectFromField(ref this.animationTable, false); }
            set { this.SetISettableToField(ref this.animationTable, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterAnimationCommonData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableAnimation = srcDataModel.EnableAnimation;
            this.InterpolationMode = srcDataModel.InterpolationMode;
            this.LoopMode = srcDataModel.LoopMode;
            this.AnimationTable = srcDataModel.AnimationTable;

            return true;
        }
    }
}
