﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Schema;
using System.Xml.Serialization;
using EffectMaker.DataModel.DataModels;

namespace NWCore.src.Remake.DataModel.DataModels
{
    public class CustomActionConvertingData : CustomActionSettingData
    {
        public CustomActionConvertingData()
        {
            this.Flags = 0;
            this.FlagsVisibleList = new Dictionary<int, bool>();
            this.IntParams = new List<int>();
            this.IntParamsVisibleList = new Dictionary<int, bool>();
            this.FloatParams = new List<float>();
            this.FloatParamsVisibleList = new Dictionary<int, bool>();
        }

        public string Name { get; set; }
        public bool Visible { get; set; }

        public bool FlagsVisible { get; set; }
        public Dictionary<int, bool> FlagsVisibleList { get; set; }

        public bool IntParamsVisible { get; set; }
        public Dictionary<int, bool> IntParamsVisibleList { get; set; }

        public bool FloatParamsVisible { get; set; }
        public Dictionary<int, bool> FloatParamsVisibleList { get; set; }

        public uint Flags { get; set; }
        public List<int> IntParams { get; set; }
        public List<float> FloatParams { get; set; }
    }
}
