﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_1.Minor_9.Build_0.Revision_0
{
    /// <summary>
    /// エミッタセット用データモデル
    /// </summary>
    public sealed class EmitterSetData : BaseDataModel<EmitterSetData>
    {
        #region Properties - EditData

        EditDataEmitterSet m_editData;
        /// <summary>
        /// 編集用のデータ保存用
        /// （バイナリーには影響を与えない保存用データ）
        /// </summary>
        public EditDataEmitterSet EditData
        {
            get { return m_editData; }
        }

        #endregion

        #region Properties

        /// <summary>
        /// ユーザーデータ
        /// </summary>
        public UserData UserData
        {
            get;
            set;
        }

        /// <summary>
        /// Binary version
        /// </summary>
        public Version Version
        {
            get;
            set;
        }

        /// <summary>
        /// 最終更新日
        /// </summary>
        public int LastUpdateDate
        {
            get;
            set;
        }

        /// <summary>
        /// アドレス解決後の名前
        /// </summary>
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// エミッタのリスト
        /// </summary>
//         public List<EmitterData> Emitters
//         {
//             get;
//             set;
//         }

        #endregion

        #region Construtors

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public EmitterSetData()
        {
            m_editData = new EditDataEmitterSet();

            this.UserData = new UserData();
//            this.Emitters = new List<EmitterData>();

            RestoreCurrentVersion();

            Initialize();
        }

        /// <summary>
        /// コピーコンストラクタ
        /// </summary>
        /// <param name="source">コピー元のベクトル</param>
        public EmitterSetData(EmitterSetData source)
            : this()
        {
            this.Set(source);
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            // EditDataのコピー
            this.EditData.Initialize();

            //
            this.UserData.Initialize();
        }


        /// <summary>
        /// Restore the current version.
        /// </summary>
        public void RestoreCurrentVersion()
        {
            this.Version = new Version( 1, 9, 0, 0 );
        }

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するベクトルです</param>
        public override void Set(EmitterSetData source)
        {
            Ensure.Argument.NotNull(source);

            // EditDataのコピー
            this.EditData.Set(source.EditData);

            //
            this.Name = source.Name;
            this.Version = source.Version.Clone() as Version;
            this.LastUpdateDate = source.LastUpdateDate;

            this.UserData.Set(source.UserData);
        }

        /// <summary>
        /// オブジェクトを複製します。
        /// </summary>
        /// <returns>複製したオブジェクトです。</returns>
        public override EmitterSetData Clone()
        {
            return new EmitterSetData(this);
        }

        #endregion
    }
}
