﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_1.Minor_8.Build_0.Revision_0
{
    /// <summary>
    /// アニメーション編集データ
    /// </summary>
    public sealed class AnimEditData : BaseDataModel<AnimEditData>
    {
        #region Properties

        /// <summary>
        ///
        /// </summary>
        public int UI_life { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_lifeRnd { get; set; }

        /// <summary>
        /// アルファアニメタイプ。
        /// </summary>
        public ParticleAnimationTypes UI_alphaAnimType { get; set; }

        /// <summary>
        ///
        /// </summary>
        public float UI_alpha1 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public float UI_alpha2 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public float UI_alpha3 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_alphaTime1 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_alphaTime2 { get; set; }

        /// <summary>
        /// スケールアニメタイプ。
        /// </summary>
        public ParticleAnimationTypes UI_scaleAnimType { get; set; }

        /// <summary>
        /// エミッタのスケールをマイナス指定
        /// </summary>
        public bool UI_NegativeScaleRangeEnabled { get; set; }

        /// <summary>
        /// 速度をＹスケールに加算。
        /// </summary>
        public float UI_scaleVelAddY { get; set; }

        /// <summary>
        /// 初期スケール(%)
        /// </summary>
        public Vector2i UI_scale1 { get; set; }

        /// <summary>
        /// スケール基準値
        /// </summary>
        public Vector2 UI_scale2 { get; set; }

        /// <summary>
        /// 中間スケール(%)
        /// </summary>
        public Vector2i UI_scale2Relative { get; set; }

        /// <summary>
        /// 終了スケール(%)
        /// </summary>
        public Vector2i UI_scale3 { get; set; }

        /// <summary>
        /// イン完了タイミング(%)
        /// </summary>
        public int UI_scaleTime1 { get; set; }

        /// <summary>
        /// アウト開始タイミング(%)
        /// </summary>
        public int UI_scaleTime2 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public uint UI_lifeInfinit { get; set; }

        /// <summary>
        /// カラー０
        /// </summary>
        public ColorEditData Color0 { get; set; }

        /// <summary>
        /// カラー１
        /// </summary>
        public ColorEditData Color1 { get; set; }

        /// <summary>
        /// アルファ0
        /// </summary>
        public AlphaAnimData Alpha0 { get; set; }

        /// <summary>
        /// アルファ１
        /// </summary>
        public AlphaAnimData Alpha1 { get; set; }

        #endregion

        #region Construtors

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public AnimEditData()
        {
            this.UI_scale1 = new Vector2i();
            this.UI_scale2 = new Vector2();
            this.UI_scale2Relative = new Vector2i();
            this.UI_scale3 = new Vector2i();
            this.Color0 = new ColorEditData();
            this.Color1 = new ColorEditData();
            this.Alpha0 = new AlphaAnimData();
            this.Alpha1 = new AlphaAnimData();
        }

        /// <summary>
        /// コピーコンストラクタ
        /// </summary>
        /// <param name="source">コピー元のベクトル</param>
        public AnimEditData(AnimEditData source)
        {
            this.Set(source);
        }

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            this.UI_alphaAnimType = ParticleAnimationTypes.InOutAnim;
            this.UI_alpha1 = 0.0f;
            this.UI_alpha2 = 1.0f;
            this.UI_alpha3 = 0.0f;
            this.UI_alphaTime1 = 0;
            this.UI_alphaTime2 = 100;

            this.UI_life = 100;
            this.UI_lifeRnd = 0;

            this.UI_scaleAnimType = ParticleAnimationTypes.InOutAnim;
            this.UI_NegativeScaleRangeEnabled = false;
            this.UI_scaleVelAddY = 0.0f;
            this.UI_scale1.Set(0, 0);
            this.UI_scale2.Set(1, 1);
            this.UI_scale2Relative.Set(100, 100);
            this.UI_scale3.Set(200, 200);
            this.UI_scaleTime1 = 0;
            this.UI_scaleTime2 = 100;

            this.UI_lifeInfinit = 0;

            this.Color0.Initialize();
            this.Color1.Initialize();
            this.Alpha0.Initialize();
            this.Alpha1.Initialize();

            float worldScale = s_WorldScaleRange / 100.0f;
            {
                this.UI_scale2.Set(1.0f * worldScale, 1.0f * worldScale);
            }
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// 設定
        /// </summary>
        public override void Set(AnimEditData source)
        {
            Ensure.Argument.NotNull(source);

            this.UI_life = source.UI_life;
            this.UI_lifeRnd = source.UI_lifeRnd;

            this.UI_alphaAnimType = source.UI_alphaAnimType;
            this.UI_alpha1 = source.UI_alpha1;
            this.UI_alpha2 = source.UI_alpha2;
            this.UI_alpha3 = source.UI_alpha3;
            this.UI_alphaTime1 = source.UI_alphaTime1;
            this.UI_alphaTime2 = source.UI_alphaTime2;

            this.UI_scaleAnimType = source.UI_scaleAnimType;
            this.UI_NegativeScaleRangeEnabled = source.UI_NegativeScaleRangeEnabled;
            this.UI_scaleVelAddY = source.UI_scaleVelAddY;
            this.UI_scale1.Set(source.UI_scale1);
            this.UI_scale2.Set(source.UI_scale2);
            this.UI_scale2Relative.Set(source.UI_scale2Relative);
            this.UI_scale3.Set(source.UI_scale3);
            this.UI_scaleTime1 = source.UI_scaleTime1;
            this.UI_scaleTime2 = source.UI_scaleTime2;

            this.UI_lifeInfinit = source.UI_lifeInfinit;

            this.Color0.Set(source.Color0);
            this.Color1.Set(source.Color1);
            this.Alpha0.Set(source.Alpha0);
            this.Alpha1.Set(source.Alpha1);
        }

        /// <summary>
        /// オブジェクトを複製します。
        /// </summary>
        /// <returns>複製したオブジェクトです。</returns>
        public override AnimEditData Clone()
        {
            return new AnimEditData(this);
        }

        #endregion
    }
}
