﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_1.Minor_4.Build_0.Revision_0
{
    /// <summary>
    /// 揺らぎパラメータ
    /// </summary>
    public sealed class FluctuationData : BaseDataModel<FluctuationData>
    {
        #region Properties

        /// <summary>
        /// 振幅
        /// </summary>
        public float Scale { get; set; }

        /// <summary>
        /// 周波数
        /// </summary>
        public int Frequency { get; set; }

        /// <summary>
        /// 位相ランダム( 0 or 1 )
        /// </summary>
        public uint PhaseRange { get; set; }

        #endregion

        #region Construtors

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public FluctuationData()
        {
        }

        /// <summary>
        /// コピーコンストラクタ
        /// </summary>
        /// <param name="source">コピー元のベクトル</param>
        public FluctuationData(FluctuationData source)
            : this()
        {
            this.Set(source);
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            this.Scale = 1.0f;
            this.PhaseRange = 0;
            this.Frequency = 20;
        }

        /// <summary>
        /// ベクトルを設定します
        /// </summary>
        /// <param name="source">設定するベクトルです</param>
        public override void Set(FluctuationData source)
        {
            Ensure.Argument.NotNull(source);

            this.Scale = source.Scale;
            this.Frequency = source.Frequency;
            this.PhaseRange = source.PhaseRange;
        }

        /// <summary>
        /// オブジェクトを複製します。
        /// </summary>
        /// <returns>複製したオブジェクトです。</returns>
        public override FluctuationData Clone()
        {
            return new FluctuationData(this);
        }

        #endregion
    }
}
