﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
#define FOR_LOADING_OLDESET

using System;
using System.Collections.Generic;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_1.Minor_3.Build_0.Revision_0
{
    /// <summary>
    /// 固定値
    /// </summary>
    public static class Constances
    {
        #region ColorCommonType

        /// <summary>
        /// カラータイプ用
        /// gHostIOColorTypeNames と並びを合わせる必要があります。
        /// </summary>
        public enum ColorCommonType
        {
            /// <summary>00:ConstColor</summary>
            ConstColor,
            /// <summary>01:ConstColor * Texture</summary>
            Modulate,
            /// <summary>02:ConstColor * Texture + Color1 * (1-Texture)</summary>
            TwoColorInterpolateNoAnim,
            /// <summary>03:ConstColor * Texture + Color1</summary>
            AddColor,
        }

        /// <summary>
        /// カラータイプ用
        /// gHostIOColorTypeNames と並びを合わせる必要があります。
        /// </summary>
        public enum ColorSettingType
        {
            /// <summary>00:固定</summary>
            Constant,
            /// <summary>01:ランダム</summary>
            Random,
            /// <summary>02:アニメ</summary>
            Animation,
        }

        /// <summary>
        /// カラータイプ名
        /// ColorCommonType と並びを合わせる必要があります。
        /// </summary>
        static readonly string[] gHostIOColorTypeNames = new string[]
        {
            /*00*/"ConstColor" ,
            /*01*/"ModulateTex" ,
            /*02*/"2ColorInterpolate" ,
            /*03*/"AddColor" ,
        };

        #endregion

        #region ColorInheritType

        /// <summary>
        /// カラー継承タイプ
        /// gHostIOColorInheritTypeNames の並びとあわせる必要があります。
        /// </summary>
        public enum ColorInheritType
        {
            /// <summary>00:継承カラー</summary>
            InheritanceColorNoTex,
            /// <summary>01:継承カラー　×　TEX</summary>
            ModulateNoAnim,
            /// <summary>02:継承カラー　×　TEX　＋　固定カラー ×（1-TEX）</summary>
            TwoColorInterpolateNoAnim,
            /// <summary>03:固定カラー　×　TEX　＋　継承カラー ×（1-TEX）</summary>
            Inv2ColorInterpolateNoAnim,
            /// <summary>04:固定カラー　×　TEX　＋　継承カラー</summary>
            InheritanceColorAdd,
        }

        /// <summary>
        /// カラー継承タイプ名
        /// ColorInheritType の並びとあわせる必要があります。
        /// </summary>
        static readonly string[] gHostIOColorInheritTypeNames = new string[]
        {
            /*00*/"InheritanceColorNoTex" ,
            /*01*/"Modulate(no anim)" ,
            /*02*/"2ColorInterpolate(no anim)" ,
            /*03*/"Inv2ColorInterpolate(no anim)" ,
            /*04*/"InheritanceColorAdd" ,
        };

        #endregion

        #region Utilites

        /// <summary>
        /// カラータイプ名
        /// </summary>
        public static string GetColorTypeName(ColorCommonType type)
        {
            Debug.Assert(gHostIOColorTypeNames.Length > (int)type,
                String.Format("ERROR : 未知のカラータイプです。{0}", type.ToString()));
            //
            return gHostIOColorTypeNames[(int)type];
        }

        /// <summary>
        /// カラータイプ名でカラータイプを設定します。
        /// </summary>
        /// <param name="name"></param>
        public static ColorCommonType SetColorTypeName(string name)
        {
            int index = 0;
            foreach (var item in gHostIOColorTypeNames)
            {
                if (name.Equals(item, StringComparison.CurrentCultureIgnoreCase))
                {
                    return (ColorCommonType)index;
                }
                index++;
            }

            // 旧データの対応（名前違いのとき）
            if (name.Equals("ColorOnly", StringComparison.CurrentCultureIgnoreCase))
            {
                return ColorCommonType.ConstColor;
            }

            // 旧データの対応（数字のとき）
            int colorTypeNum = 0;
            try
            {
                colorTypeNum = int.Parse(name);
                if (colorTypeNum >= 0)
                {
                    return (ColorCommonType)colorTypeNum;
                }
            }
            catch (Exception ex)
            {
                DebugConsole.DebugConsole.Instance.WriteLine(ex.Message);
            }

            // ここに来たらエラーです。
            Debug.Assert(false, String.Format("ERROR : 未知のカラータイプ名です。{0}", name));
            return 0;
        }

        /// <summary>
        /// カラー継承タイプ名
        /// </summary>
        public static string GetColorInheritTypeNames(ColorInheritType type)
        {
            Debug.Assert(gHostIOColorInheritTypeNames.Length > (int)type,
                String.Format("ERROR : 未知のカラータイプです。{0}", type.ToString()));
            //
            return gHostIOColorInheritTypeNames[(int)type];
        }

        /// <summary>
        /// カラー継承タイプ名でカラー継承タイプを設定します。
        /// </summary>
        public static ColorInheritType SetColorInheritTypeNames(string name)
        {
            int index = 0;
            foreach (var item in gHostIOColorInheritTypeNames)
            {
                if (name.Equals(item, StringComparison.CurrentCultureIgnoreCase))
                {
                    return (ColorInheritType)index;
                }
                index++;
            }
            // ここに来たらエラーです。
            Debug.Assert(false, String.Format("ERROR : 未知のカラータイプ名です。{0}", name));
            return 0;
        }

        #endregion
    }

}
