﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_1.Minor_2.Build_0.Revision_0
{
    #region enum - SystemInfo
    /// <summary>
    /// 定数定義
    /// </summary>
    public enum SystemInfo
    {
        /// <summary>
        /// 現在のバージョン
        /// </summary>
        CurrentVersion    = 0x00000005,
        /// <summary>
        /// エミッタセットの中の最大エミッタ個数
        /// </summary>
        NumEmitterInSet   = 8,
        /// <summary>
        /// HostIOメタデータのサイズ
        /// </summary>
        MetaBufSize       = 128,
        /// <summary>
        /// テクスチャーパターンテーブル数
        /// </summary>
        NumTexPatTbl      = 16,
        /// <summary>
        /// 名前ラベルのＩＤ
        /// </summary>
        NameLabelID       = 0x100000,
        /// <summary>
        /// モデルボーンの最大長
        /// </summary>
        BoneNameLen	   = 128,
        /// <summary>
        /// 寿命無限の時のライフ ( 414日 )
        /// </summary>
        InfinitLife	   = 0x7fffffff
    }
    #endregion

    #region enum - TargetMachine
    /// <summary>
    /// ◆ターゲットマシン
    /// </summary>
    public enum TargetMachine
    {
        /// <summary></summary>
        Ctr,
        /// <summary></summary>
        Win,
        /// <summary></summary>
        Cafe,
        /// <summary></summary>
        All,
        /// <summary></summary>
        Auto
    }
    #endregion

    #region enum - RuntimeError
    /// <summary>
    /// ランタイムエラーコード
    /// </summary>
    enum RuntimeError
    {
        /// <summary>
        /// エラー無し
        /// </summary>
        None = 0,
        /// <summary>
        /// ディレクショナルパーティクルの速度が小さすぎる
        /// </summary>
        DirectionalVelMin,
        /// <summary>
        /// ディレクショナルパーティクルの速度と方向が一致しすぎている
        /// </summary>
        DirectionalVelUpSameDir
    }
    #endregion

    #region enum - FadeOutType

    public enum FadeOutType
    {
        /// <summary>
        /// パーティクルの放出を止める
        /// </summary>
        StopEmit = 0,

        /// <summary>
        /// αフェード
        /// </summary>
        AlphaFade,

        /// <summary>
        /// パーティクルの放出を止め、かつαフェード
        /// </summary>
        StopEmitAlphaFade,

        /// <summary>
        /// force it to be 4 byte long
        /// </summary>
        Force4Byte = 0x7fffffff
    }

    #endregion

    /* deprecated - to be deleted later
    #region enum - EndFrameFlg
    /// <summary>
    /// PtclSystem::endFrameに渡すフラグ
    /// </summary>
    public enum EndFrameFlg
    {
        /// <summary>
        /// CTRでストライプ頂点バッファーのキャッシュフラッシュを行う
        /// </summary>
        StripeVertexCacheFlush = (1 << 0),
        /// <summary>
        /// end frame is none
        /// </summary>
        None = 0
    }
    #endregion
    */

    #region enum - BufferLocation
    /// <summary>
    /// バッファーロケーション
    /// </summary>
    public enum BufferLocation
    {
        /// <summary>
        /// FCRAMに配置
        /// </summary>
        FCRAM = 0,
        /// <summary>
        /// VRAMAに配置（nngxInitializeで渡したアロケーターから確保されます)
        /// </summary>
        VRAMA,
        /// <summary>
        /// VRAMBに配置（nngxInitializeで渡したアロケーターから確保されます）
        /// </summary>
        VRAMB,
        /// <summary>
        /// Default
        /// </summary>
        Default = FCRAM
    }
    #endregion

    #region enum - ModelAnimType

    /// <summary>
    /// モデルアニメーションタイプ
    /// </summary>
    public enum ModelAnimType
    {
        /// <summary></summary>
        Chr,
        /// <summary></summary>
        Mat,
        /// <summary></summary>
        Vis,
        /// <summary></summary>
        NumModelAnimType,

        /// <summary>
        /// force it to be 4 bytes long
        /// </summary>
        Force4Byte = 0x8000000
    }

    #endregion

    #region enum - TextureAddressing
    /// <summary>
    /// テクスチャーアドレッシング
    /// </summary>
    public enum TextureAddressing
    {
        /// <summary>
        /// 通常のアドレッシング
        /// </summary>
        Normal = 0,
        /// <summary>
        /// Ｕ方向に２倍のミラー
        /// </summary>
        MirrorU2,
        /// <summary>
        /// Ｖ方向に２倍のミラー
        /// </summary>
        MirrorV2,
        /// <summary>
        /// ＵＶ方向に２倍のミラー
        /// </summary>
        MirrorU2V2,
        /// <summary>
        ///
        /// </summary>
        NumTextureAddressing,

        /// <summary>
        /// force it to be 4 bytes long
        /// </summary>
        Force4Byte = 0x7fffffff
    }
    #endregion

    #region enum - Group

    /// <summary>
    /// グループ
    /// </summary>
    public enum Group
    {
        /// <summary>
        /// 最大グループ数
        /// </summary>
        Max = 8,
    }

    #endregion

    #region enum - CpuCore

    /// <summary>
    /// Cpuコア
    /// </summary>
    public enum CpuCore
    {
        /// <summary>
        /// コア1
        /// </summary>
        CpuCore0 = 0,

        /// <summary>
        /// コア0
        /// </summary>
        CpuCore1 = 1,

        /// <summary>
        /// 最大CPUコア数
        /// </summary>
        MaxCpuCore = 2,
    }

    #endregion

    #region enum - EmitterType

    /// <summary>
    /// エミッタタイプ
    /// </summary>
    public enum EmitterType
    {
        /// <summary></summary>
        Simple = 0,
        /// <summary></summary>
        Complex,
        /// <summary></summary>
        Type,
        /// <summary></summary>
        Force4Byte = 0x7fffffff
    }

    #endregion

    #region enum - FollowType
    /// <summary>
    /// 追従タイプ
    /// </summary>
    public enum FollowType
    {
        /// <summary>
        /// 完全追従
        /// </summary>
        All = 0,
        /// <summary>
        /// 追従しない
        /// </summary>
        None,
        /// <summary>
        /// 位置だけ追従
        /// </summary>
        PosOnly,
        /// <summary>
        ///
        /// </summary>
        Type,

        /// <summary>
        /// force it to be 4 bytes
        /// </summary>
        Force4Byte = 0x7fffffff
    }
    #endregion

    #region enum - PtclPreCalcType
    /// <summary>
    /// パーティクル計算タイプ（前半）
    /// </summary>
    public enum PtclPreCalcType
    {
        /// <summary></summary>
        FollowAll = 0,
        /// <summary></summary>
        FollowNone,
        /// <summary></summary>
        FollowPosOnly,
        /// <summary></summary>
        Type,
        /// <summary>
        /// force it to be 4 bytes
        /// </summary>
        Force4Byte = 0x7fffffff
    }
    #endregion

    #region enum - VolumeType
    /// <summary>
    /// ボリュームタイプ
    /// </summary>
    public enum VolumeType
    {
        /// <summary>
        /// 点
        /// </summary>
        Point = 0,

        /// <summary>
        /// 円
        /// </summary>
        Circle,
        /// <summary></summary>
        CircleSameDivide,
        /// <summary></summary>
        FillCircle,
        //FillCircleSameDivide,

        /// <summary>
        /// 球
        /// </summary>
        Sphere,
        /// <summary></summary>
        SphereSameDivide,
        /// <summary>64 version</summary>
        SphereSameDivide64,
        /// <summary></summary>
        FillSphere,
        /// <summary></summary>
        //FillSphereSameDivide,

        /// <summary>
        /// 円柱
        /// </summary>
        Cylinder,
        /// <summary></summary>
        FillCylinder,

        /// <summary>
        /// 立方体
        /// </summary>
        Box,
        /// <summary></summary>
        FillBox,

        /// <summary>
        /// 線
        /// </summary>
        Line,
        /// <summary></summary>
        LineSameDivide,

        /// <summary>
        /// 矩形
        /// </summary>
        Rectangle,

        /// <summary>
        /// 数
        /// </summary>
        NumVolumeType,

        /// <summary>
        /// force it 4 bytes
        /// </summary>
        Force4Byte = 0x7fffffff
    }
    #endregion

    #region enum - BlendType
    /// <summary>
    /// ブレンドタイプ
    /// </summary>
    public enum BlendType
    {
        /// <summary>
        /// 通常のブレンド
        /// </summary>
        Normal = 0,
        /// <summary>
        /// 加算
        /// </summary>
        Add,
        /// <summary>
        /// 減算
        /// </summary>
        Sub,
        /// <summary>
        /// スクリーン
        /// </summary>
        Screen,
        /// <summary>
        /// 乗算
        /// </summary>
        Multiply,
        /// <summary>
        /// ブレンド無し（UI設定はなし
        /// </summary>
        None,
        /// <summary>
        ///
        /// </summary>
        NumBlendType,
        /// <summary>
        /// force it to be 4 bytes long
        /// </summary>
        Force4Byte = 0x7fffffff
    }
    #endregion

    #region enum - ZBufATestType
    /// <summary>
    /// Ｚバッファー、αテスト関連
    /// </summary>
    public enum ZBufATestType
    {
        /// <summary>
        /// ブレンド有り 通常の状態（Ｚ比較あり、Ｚ書き込みなし、αテスト０より大きいが合格）
        /// </summary>
        Normal = 0,
        /// <summary>
        /// ブレンド有り Ｚ無視（Ｚ比較なし、Ｚ書き込みなし、αテスト０より大きいが合格）
        /// </summary>
        ZIgnore,
        /// <summary>
        /// ブレンド無し 実体Ｚ（比較あり、Ｚ書き込み有り、αテスト0.5以上が合格）
        /// </summary>
        Entity,
        /// <summary>
        ///
        /// </summary>
        NumZBufATestType,
        /// <summary>
        /// force it to be 4 bytes long
        /// </summary>
        Force4Byte = 0x7fffffff
    }
    #endregion

    #region enum - PtclRotType
    /// <summary>
    /// 回転タイプ
    /// </summary>
    public enum PtclRotType
    {
        /// <summary>
        /// 何もしない
        /// </summary>
        NoWork = 0,
        /// <summary>
        /// Ｘ回転
        /// </summary>
        RotateX,
        /// <summary>
        /// Ｙ回転
        /// </summary>
        RotateY,
        /// <summary>
        /// Ｚ回転
        /// </summary>
        RotateZ,
        /// <summary>
        /// ＸＹＺ回転
        /// </summary>
        RotateXYZ,
        /// <summary>
        ///
        /// </summary>
        cNumcPtclRotType,
        /// <summary>
        /// force it to be 4 bytes long
        /// </summary>
        Force4Byte = 0x7fffffff
    }
    #endregion

    #region enum - ColorCalcType
    /// <summary>
    /// カラー計算タイプ
    /// </summary>
    public enum ColorCalcType
    {
        /// <summary>
        /// 何もしない
        /// </summary>
        NoWork = 0,
        /// <summary>
        /// Color1をそのまま流す
        /// </summary>
        PassColor1,
        /// <summary>
        /// ３色を線形補間　周期機能付き
        /// </summary>
        Linear3Color,
        /// <summary>
        ///
        /// </summary>
        NumColorCalcType,
        /// <summary>
        /// force it to be 4 bytes long
        /// </summary>
        Force4Byte = 0x7fffffff
    }
    #endregion

    #region enum - PtclCalcType
    /// <summary>
    /// パーティクル計算タイプ（回転タイプとカラー計算タイプの合成）
    /// </summary>
    public enum PtclCalcType
    {
        /// <summary></summary>
        RotNoWork_ColorNoWork = 0,
        /// <summary></summary>
        RotX_ColorNoWork,
        /// <summary></summary>
        RotY_ColorNoWork,
        /// <summary></summary>
        RotZ_ColorNoWork,
        /// <summary></summary>
        RotXYZ_ColorNoWork,

        /// <summary></summary>
        RotNoWork_PassColor1,
        /// <summary></summary>
        RotX_PassColor1,
        /// <summary></summary>
        RotY_PassColor1,
        /// <summary></summary>
        RotZ_PassColor1,
        /// <summary></summary>
        RotXYZ_PassColor1,

        /// <summary></summary>
        RotNoWork_Linear3Color,
        /// <summary></summary>
        RotX_Linear3Color,
        /// <summary></summary>
        RotY_Linear3Color,
        /// <summary></summary>
        RotZ_Linear3Color,
        /// <summary></summary>
        RotXYZ_Linear3Color,

        /// <summary></summary>
        NumPtclCalcType,
        /// <summary>
        /// force it to be 4 bytes long
        /// </summary>
        Force4Byte = 0x7fffffff
    }
    #endregion

    #region enum - CombinerType
    /// <summary>
    /// コンバイナタイプ
    /// </summary>
    public enum CombinerType
    {
        /// <summary>
        /// コンスタントカラー×テクスチャー
        /// </summary>
        ConstColor_Modulate_Texture = 0,
        /// <summary>
        /// パーティクルカラー×テクスチャー
        /// </summary>
        PtclColor_Modulate_Texture,
        /// <summary>
        /// 二色補間（メインはコンスタントカラー）
        /// </summary>
        TwoColorInterpolate,
        /// <summary>
        /// 二色補間（メインはパーティクルカラー）
        /// </summary>
        InvTwoColorInterpolate,
        /// <summary>
        /// コンスタントカラー
        /// </summary>
        ConstColor,
        /// <summary>
        /// パーティクルカラー
        /// </summary>
        PtclColor,
        /// <summary>
        /// パーティクルカラーを加算
        /// </summary>
        AddPtclColor,

        /// <summary>
        /// 【α減算】コンスタントカラー×テクスチャー
        /// </summary>
        ConstColor_Modulate_Texture_AlphaSub,
        /// <summary>
        /// 【α減算】パーティクルカラー×テクスチャー
        /// </summary>
        PtclColor_Modulate_Texture_AlphaSub,
        /// <summary>
        /// α減算】二色補間（メインはコンスタントカラー）
        /// </summary>
        TwoColorInterpolate_AlphaSub,
        /// <summary>
        /// 【α減算】二色補間（メインはパーティクルカラー）
        /// </summary>
        InvTwoColorInterpolate_AlphaSub,
        /// <summary>
        /// 【α減算】コンスタントカラー
        /// </summary>
        ConstColor_AlphaSub,
        /// <summary>
        /// α減算】パーティクルカラー
        /// </summary>
        PtclColor_AlphaSub,
        /// <summary>
        /// 【α減算】パーティクルカラーを加算
        /// </summary>
        AddPtclColor_AlphaSub,

        /// <summary>
        /// Texα＝TexR】コンスタントカラー×テクスチャー
        /// </summary>
        ConstColor_Modulate_Texture_AlphaR,
        /// <summary>
        /// 【Texα＝TexR】パーティクルカラー×テクスチャー
        /// </summary>
        PtclColor_Modulate_Texture_AlphaR,
        /// <summary>
        /// 【Texα＝TexR】二色補間（メインはコンスタントカラー）
        /// </summary>
        TwoColorInterpolate_AlphaR,
        /// <summary>
        /// 【Texα＝TexR】二色補間（メインはパーティクルカラー）
        /// </summary>
        InvTwoColorInterpolate_AlphaR,
        /// <summary>
        /// 【Texα＝TexR】コンスタントカラー
        /// </summary>
        ConstColor_AlphaR,
        /// <summary>
        /// 【Texα＝TexR】パーティクルカラー
        /// </summary>
        PtclColor_AlphaR,
        /// <summary>
        /// 【Texα＝TexR】パーティクルカラーを加算
        /// </summary>
        AddPtclColor_AlphaR,

        /// <summary>
        /// 【Texα＝TexR】【α減算】コンスタントカラー×テクスチャー
        /// </summary>
        ConstColor_Modulate_Texture_AlphaSub_AlphaR,
        /// <summary>
        /// 【Texα＝TexR】【α減算】パーティクルカラー×テクスチャー
        /// </summary>
        PtclColor_Modulate_Texture_AlphaSub_AlphaR,
        /// <summary>
        /// 【Texα＝TexR】【α減算】二色補間（メインはコンスタントカラー）
        /// </summary>
        TwoColorInterpolate_AlphaSub_AlphaR,
        /// <summary>
        /// 【Texα＝TexR】【α減算】二色補間（メインはパーティクルカラー）
        /// </summary>
        InvTwoColorInterpolate_AlphaSub_AlphaR,
        /// <summary>
        /// 【Texα＝TexR】【α減算】コンスタントカラー
        /// </summary>
        ConstColor_AlphaSub_AlphaR,
        /// <summary>
        /// 【Texα＝TexR】【α減算】パーティクルカラー
        /// </summary>
        PtclColor_AlphaSub_AlphaR,
        /// <summary>
        /// 【Texα＝TexR】【α減算】パーティクルカラーを加算
        /// </summary>
        AddPtclColor_AlphaSub_AlphaR,

        /// <summary>
        ///
        /// </summary>
        NumCombinerType,
        /// <summary>
        /// force it to be 4 bytes long
        /// </summary>
        Force4Byte = 0x7fffffff
    }
    #endregion

    #region enum - AlphaDst
    /// <summary>
    /// α出力タイプ
    /// </summary>
    public enum AlphaDst
    {
        /// <summary>テクスチャーと乗算</summary>
        ModulateTex = 0,

        /// <summary>テクスチャーから減算</summary>
        SubtractFromTex,

        /// <summary>テクスチャーとアルファを乗算</summary>
        ModulateTexAlphaR,

        /// <summary>テクスチャーからとアルファを減算</summary>
        SubtractFromTexAlphaR,

        /// <summary>
        /// 最大数
        /// </summary>
        NumAlphaDst,
        /// <summary>
        /// force it to be 4 bytes long
        /// </summary>
        Force4Byte = 0x7fffffff
    }
    #endregion

    #region enum - MeshType
    /// <summary>
    /// Mesh type
    /// </summary>
    public enum MeshType
    {
        Particle = 0,
        Primitive,
        Stripe,
        /// <summary>
        /// force it to be 4 bytes long
        /// </summary>
        Force4Byte = 0x7fffffff
    }
    #endregion

    #region enum - BillboardType
    /// <summary>
    /// ビルボードタイプ
    /// </summary>
    public enum BillboardType
    {
        /// <summary>
        /// 普通のビルボード
        /// </summary>
        Billboard = 0,
        /// <summary>
        /// XY平面のポリゴン
        /// </summary>
        PolygonXY,
        /// <summary>
        /// XZ平面のポリゴン
        /// </summary>
        PolygonXZ,
        /// <summary>
        /// 速度方向を向くビルボード
        /// </summary>
        VelLook,
        /// <summary>
        /// 速度方向を向くポリゴン
        /// </summary>
        VelLookPolygon,
        /// <summary>
        /// ストライプ
        /// </summary>
        Stripe,
        /// <summary>
        /// ストライプ(高機能タイプ)
        /// </summary>
        ComplexStripe,

        /// <summary>
        /// プリミティブ
        /// </summary>
        Primitive,

        /// <summary>
        ///
        /// </summary>
        NumcBillboardType,
        /// <summary>
        /// force it to be 4 bytes long
        /// </summary>
        Force4Byte = 0x7fffffff
    }
    #endregion

    #region enum - TextureWrapMode
    /// <summary>
    /// ラップモード
    /// </summary>
    public enum TextureWrapMode
    {
        /// <summary>
        /// ミラー
        /// </summary>
        Mirror,
        /// <summary>
        /// リピート
        /// </summary>
        Repeat,
        /// <summary>
        /// クランプ
        /// </summary>
        Clamp,
        /// <summary>
        /// ミラーワンス
        /// </summary>
        MirrorOnce
    }
    #endregion

    #region enum - FilterMode
    /// <summary>
    /// フィルタモード
    /// </summary>
    public enum FilterMode
    {
        /// <summary>
        /// リニア
        /// </summary>
        Linear,
        /// <summary>
        /// ニア
        /// </summary>
        Near,
    }

    #endregion

    #region enum - FieldKind
    /// <summary>
    /// types of the field
    /// </summary>
    public enum FieldKind
    {
        /// <summary></summary>
        Random ,
        /// <summary></summary>
        Magnet ,
        /// <summary></summary>
        Spin ,
        /// <summary></summary>
        Collision ,
        /// <summary></summary>
        Convergence,
        /// <summary></summary>
        PosAdd ,
        /// <summary></summary>
        NumFieldKind
    }
    #endregion

    #region enum - FlunctuationTbl
    /// <summary>
    /// table of fluctuation
    /// </summary>
    public enum FluctuationTbl
    {
        /// <summary>
        /// 揺らぎテーブルの個数
        /// </summary>
        Num = 128,
        /// <summary>
        /// マスク値
        /// </summary>
        NumMask = 127
    }
    #endregion

    #region enum - StripeFlag
    /// <summary>
    /// flag of stripe
    /// </summary>
    public enum StripeFlag
    {
        /// <summary>
        /// エミッタ座標系でストライプをかける
        /// </summary>
        EmitterCoord = ( 1 << 0 )
    }
    #endregion

    #region enum - FieldCollisionReaction
    /// <summary>
    /// reaction for filed collision
    /// </summary>
    public enum FieldCollisionReaction
    {
        /// <summary>
        /// 消滅
        /// </summary>
        Cesser = 0,
        /// <summary>
        /// 反射
        /// </summary>
        Reflection
    }
    #endregion

    #region enum - StripType
    /// <summary>
    /// type of stripe
    /// </summary>
    public enum StripeType
    {
        /// <summary>
        /// カメラを向かせるストライプを作る
        /// </summary>
        Billboard,
        /// <summary>
        /// エミッタ行列を使用してストライプを作る
        /// </summary>
        EmitterMtx,
        /// <summary>
        /// エミッタ行列の上下方向に伸ばしてストライプを作る
        /// </summary>
        EmitterUpDown,
        /// <summary>
        ///
        /// </summary>
        NumStripeType,
        /// <summary>
        /// force it to be 4 bytes
        /// </summary>
        Force4Byte = 0x7fffffff
    }
    #endregion

    #region ShaderType

    /// <summary>
    /// シェーダータイプ
    /// </summary>
    public enum ShaderType
    {
        /// <summary>
        /// 通常(シェーダーを利用しないとき)
        /// </summary>
        Particle,

        /// <summary>
        /// 屈折パーティクル
        /// </summary>
        RefrectParticle,

        /// <summary>
        /// 歪みパーティクル
        /// </summary>
        DistortionParticle
    }

    #endregion

    #region enum - MatrixSetType
    public enum MatrixSetType
    {
        /// <summary>
        /// 通常のセット
        /// </summary>
        Normal = 0,
        /// <summary>
        /// スケールを入れると正しく反映されない代わりに高速。
        /// </summary>
        Fast
    }
    #endregion

    #region enum - MtxApplyMode
    public enum MtxApplyMode
    {
        /// <summary>
        /// TRS
        /// </summary>
        TRS = 0,
        /// <summary>
        /// Tのみ
        /// </summary>
        T
    }
    #endregion

    #region enum - AutoMoveType

    public enum AutoTranslateType
    {
        /// <summary>
        /// 自動移動なし
        /// </summary>
        None = 0,

        /// <summary>
        /// XZ平面を回転
        /// </summary>
        RotateXZ
    }

    #endregion

    #region enum - FogType

    public enum FogType
    {
        /// <summary>
        /// フォグ無し
        /// </summary>
        None = 0,

        /// <summary>
        /// 線形関数
        /// </summary>
        Linear,

        /// <summary>
        /// 指数関数
        /// </summary>
        Exponential,

        /// <summary>
        /// 二次の指数関数
        /// </summary>
        SquaredExp
    }
    #endregion

    #region enum - FrameRate
    public enum InitSettingFrameRate
    {
        /// <summary>
        /// 60 fps
        /// </summary>
        FPS60 = 0,

        /// <summary>
        /// 30fps
        /// </summary>
        FPS30,

        /// <summary>
        /// 20fps
        /// </summary>
        FPS20,

        /// <summary>
        /// 10fps
        /// </summary>
        FPS15
    }
    #endregion

    #region enum - Resolution

    public enum InitSettingResolution
    {
        /// <summary>
        /// 960*540
        /// </summary>
        RES_960_540 = 0,

        /// <summary>
        /// 640*480
        /// </summary>
        RES_640_480,

        /// <summary>
        /// 1280*720
        /// </summary>
        RES_1280_720
    }
    #endregion

    #region enum - ParticleSortType
    public enum ParticleSortType
    {
        /// <summary>
        /// 昇順
        /// </summary>
        Ascending = 0,

        /// <summary>
        /// 降順
        /// </summary>
        Descending,

        /// <summary>
        /// Zソート
        /// </summary>
        ZSort
    }
    #endregion

    #region enum - AnimTimeBaseTypes
    public enum AnimTimeBaseTypes
    {
        /// <summary>
        /// Emitter
        /// </summary>
        Emitter = 0
    }
    #endregion

    #region enum - AnimInterpolationTypes
    public enum AnimInterpolationTypes
    {
        /// <summary>
        /// リニア
        /// </summary>
        Linear = 0,

        /// <summary>
        /// スムース
        /// </summary>
        Smooth
    }
    #endregion

    #region enum - AnimTableTargetTypes
    /// <summary>
    /// The applied target type for the animation table.
    /// </summary>
    public enum AnimTableTargetTypes
    {
        unknown   = -1,
        emit_rate = 0,
        ptcl_life,
        emitter_scale_x,
        emitter_scale_y,
        emitter_scale_z,
        emitter_rot_x,
        emitter_rot_y,
        emitter_rot_z,
        emitter_trans_x,
        emitter_trans_y,
        emitter_trans_z,
        color0_r,
        color0_g,
        color0_b,
        alpha,
        emitter_form_scale_x,
        all_directional_vel,
        directional_vel,
        ptcl_scale_x,
        ptcl_scale_y,
        color1_r,
        color1_g,
        color1_b,
        emitter_form_scale_y,
        emitter_form_scale_z
    }
    #endregion

    #region enum - StripeConnectTypes
    /// <summary>
    /// The connection types for stripe particles.
    /// </summary>
    public enum StripeConnectTypes
    {
        Normal = 0,   //!< 通常
        Head,         //!< 先端に繋ぐ
        Emitter,      //!< エミッタに繋ぐ
        EmitterUnbind //!< エミッタに繋いで切り離し
    }
    #endregion

    #region enum - DisplaySideTypes
    /// <summary>
    /// Display side types for the particles.
    /// </summary>
    public enum DisplaySideTypes
    {
        Both = 0, //!< 両面
        Front,    //!< 表
        Back      //!< 裏
    }
    #endregion
}
