﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_0.Minor_9.Build_0.Revision_0
{
    /// <summary>
    /// child flag
    /// </summary>
    public class ChildFlag : ISettable
    {
        /// <summary>
        ///
        /// </summary>
        public uint Flag
        {
            get
            {
                uint ret = 0;
                if (Enable)                 ret |= (1 << 0);
                if (Color0Inherit)          ret |= (1 << 1);
                if (AlphaInherit)           ret |= (1 << 2);
                if (ScaleInherit)           ret |= (1 << 3);
                if (RotateInherit)          ret |= (1 << 4);
                if (VelInherit)             ret |= (1 << 5);
                if (EmitterFollow)          ret |= (1 << 6);
                if (DispParent)             ret |= (1 << 7);
                if (WorldField)             ret |= (1 << 8);
                if (IsPolygon)              ret |= (1 << 9);
                if (IsEmitterBillboardMtx)  ret |= (1 << 10);
                if (ParentField)            ret |= (1 << 11);
                if (PreChildDraw)           ret |= (1 << 12);
                if (IsTexPatAnim)           ret |= (1 << 13);
                if (IsTexPatAnimRand)       ret |= (1 << 14);
                if (Color1Inherit)          ret |= (1 << 15);
                return ret;
            }
            set
            {
                Enable                  = (0 != (value & (1 << 0)));
                Color0Inherit           = (0 != (value & (1 << 1)));
                AlphaInherit            = (0 != (value & (1 << 2)));
                ScaleInherit            = (0 != (value & (1 << 3)));
                RotateInherit           = (0 != (value & (1 << 4)));
                VelInherit              = (0 != (value & (1 << 5)));
                EmitterFollow           = (0 != (value & (1 << 6)));
                DispParent              = (0 != (value & (1 << 7)));
                WorldField              = (0 != (value & (1 << 8)));
                IsPolygon               = (0 != (value & (1 << 9)));
                IsEmitterBillboardMtx   = (0 != (value & (1 << 10)));
                ParentField             = (0 != (value & (1 << 11)));
                PreChildDraw            = (0 != (value & (1 << 12)));
                IsTexPatAnim            = (0 != (value & (1 << 13)));
                IsTexPatAnimRand        = (0 != (value & (1 << 14)));
                Color1Inherit           = (0 != (value & (1 << 15)));
            }
        }

        /// <summary>
        /// ISettable用
        /// </summaey>
        public void Set(object source)
        {
            Ensure.Argument.True(source is ChildFlag);
            this.Flag = (source as ChildFlag).Flag;
        }

        /// <summary>
        /// チャイルドを使用するか？
        /// </summary>
        public bool Enable { get; set; }
        /// <summary>
        /// カラー0を継承するか？
        /// </summary>
        public bool Color0Inherit { get; set; }
        /// <summary>
        /// カラー1を継承するか？
        /// </summary>
        public bool Color1Inherit { get; set; }
        /// <summary>
        /// α継承するか？
        /// </summary>
        public bool AlphaInherit { get; set; }
        /// <summary>
        /// スケール継承するか？
        /// </summary>
        public bool ScaleInherit { get; set; }
        /// <summary>
        /// 回転継承するか？
        /// </summary>
        public bool RotateInherit { get; set; }
        /// <summary>
        /// 速度継承するか？
        /// </summary>
        public bool VelInherit { get; set; }
        /// <summary>
        /// エミッタに追従するか？
        /// </summary>
        public bool EmitterFollow { get; set; }
        /// <summary>
        /// 親を描画するか？
        /// </summary>
        public bool DispParent { get; set; }
        /// <summary>
        /// 重力をワールドで計算するか？
        /// </summary>
        public bool WorldField { get; set; }
        /// <summary>
        /// ポリゴンか？
        /// </summary>
        public bool IsPolygon { get; set; }
        /// <summary>
        /// エミッタ単位でビルボード行列を設定できるか？
        /// </summary>
        public bool IsEmitterBillboardMtx { get; set; }
        /// <summary>
        /// 親のフィールドを適応するか？
        /// </summary>
        public bool ParentField { get; set; }
        /// <summary>
        /// 親よりチャイルドを先に描画するか？
        /// </summary>
        public bool PreChildDraw { get; set; }
        /// <summary>
        /// テクスチャパターンアニメを行うか？
        /// </summary>
        public bool IsTexPatAnim { get; set; }
        /// <summary>
        /// テクスチャパターンアニメをランダムで開始するか？
        /// </summary>
        public bool IsTexPatAnimRand { get; set; }
    }
}
