﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_0.Minor_0.Build_0.Revision_0
{
    /// <summary>
    /// アニメーション編集データ
    /// </summary>
    public sealed class TexPatData : BaseDataModel<TexPatData>
    {
        /// <summary>
        /// TexPatTblの配列サイズ
        /// </summary>
        public const int cNumTexPatTbl = 32;

        #region Properties

        /// <summary>
        ///
        /// </summary>
        public TextureAddressing UI_textureAddressing { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_texPatDivX { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_texPatDivY { get; set; }

        /// <summary>
        ///
        /// </summary>
        public TextureWrapMode UI_texWrapU { get; set; }

        /// <summary>
        ///
        /// </summary>
        public TextureWrapMode UI_texWrapV { get; set; }

        /// <summary>
        ///
        /// </summary>
        public uint UI_texPatNumPattern { get; set; }

        /// <summary>
        ///
        /// </summary>
        public FilterMode UI_texFilterMode { get; set; }

        /// <summary>
        ///
        /// </summary>
        public string UI_texPatFileName { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_numUseTexPatTbl { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_texPatAnimMode { get; set; }

        /// <summary>
        ///
        /// </summary>
        public uint UI_texPatFreqFrame { get; set; }

        /// <summary>
        /// /*cNumTexPatTbl*/
        /// </summary>
        public int[] UI_texPatTbl { get; set; }

        /// <summary>
        /// 0:アニメなし 1:アニメ有り
        /// </summary>
        public int UI_texPatAnim { get; set; }

        #endregion

        #region Construtors

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public TexPatData()
        {
            this.UI_textureAddressing = TextureAddressing.Normal;
            this.UI_texPatTbl = new int[cNumTexPatTbl];
            this.UI_texPatFileName = string.Empty;
        }

        /// <summary>
        /// コピーコンストラクタ
        /// </summary>
        /// <param name="source">コピー元のベクトル</param>
        public TexPatData(TexPatData source)
            : this()
        {
            this.Set(source);
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            this.UI_numUseTexPatTbl = 2;
            this.UI_texPatDivX = 1;
            this.UI_texPatDivY = 1;
            this.UI_texPatFreqFrame = 1;
            this.UI_texPatNumPattern = 1;
        }

        /// <summary>
        /// ベクトルを設定します
        /// </summary>
        /// <param name="source">設定するベクトルです</param>
        public override void Set(TexPatData source)
        {
            Ensure.Argument.NotNull(source);

            this.UI_texPatFileName = source.UI_texPatFileName;
            this.UI_textureAddressing = source.UI_textureAddressing;
            this.UI_texPatDivX = source.UI_texPatDivX;
            this.UI_texPatDivY = source.UI_texPatDivY;
            this.UI_texWrapU = source.UI_texWrapU;
            this.UI_texWrapV = source.UI_texWrapV;
            this.UI_texPatNumPattern = source.UI_texPatNumPattern;
            this.UI_texFilterMode = source.UI_texFilterMode;
            this.UI_texPatAnimMode = source.UI_texPatAnimMode;
            this.UI_texPatFreqFrame = source.UI_texPatFreqFrame;

            this.UI_numUseTexPatTbl = source.UI_numUseTexPatTbl;
            for (int i = 0; i < cNumTexPatTbl; ++i)
            {
                this.UI_texPatTbl[i] = source.UI_texPatTbl[i];
            }

            this.UI_texPatAnim = source.UI_texPatAnim;
        }

        /// <summary>
        /// オブジェクトを複製します。
        /// </summary>
        /// <returns>複製したオブジェクトです。</returns>
        public override TexPatData Clone()
        {
            return new TexPatData(this);
        }

        #endregion
    }
}

