﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_0.Minor_0.Build_0.Revision_0
{
    /// <summary>
    /// アニメーション編集データ
    /// </summary>
    public sealed class AnimEditData : BaseDataModel<AnimEditData>
    {
        #region Properties

        /// <summary>
        ///
        /// </summary>
        public int UI_life { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_lifeRnd { get; set; }

        /// <summary>
        ///
        /// </summary>
        public float UI_alpha1 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public float UI_alpha2 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public float UI_alpha3 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_alphaTime1 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_alphaTime2 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector2i UI_scale1 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector2 UI_scale2 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector2i UI_scale3 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_scaleTime1 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_scaleTime2 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public RgbaColor UI_color1 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public RgbaColor UI_color2 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public RgbaColor UI_color3 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_colorTime1 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_colorTime2 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_colorTime3 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_numColorRepeat { get; set; }

        /// <summary>
        ///
        /// </summary>
        public uint UI_lifeInfinit { get; set; }

        #endregion

        #region Construtors

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public AnimEditData()
        {
            this.UI_scale1 = new Vector2i();
            this.UI_scale2 = new Vector2();
            this.UI_scale3 = new Vector2i();
            this.UI_color1 = new RgbaColor();
            this.UI_color2 = new RgbaColor();
            this.UI_color3 = new RgbaColor();
        }

        /// <summary>
        /// コピーコンストラクタ
        /// </summary>
        /// <param name="source">コピー元のベクトル</param>
        public AnimEditData(AnimEditData source)
        {
            this.Set(source);
        }

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            this.UI_alpha1 = 0.0f;
            this.UI_alpha2 = 1.0f;
            this.UI_alpha3 = 0.0f;
            this.UI_alphaTime1 = 0;
            this.UI_alphaTime2 = 100;
            this.UI_color1.Set(1.0f, 1.0f, 1.0f, 1.0f);
            this.UI_color2.Set(1.0f, 1.0f, 1.0f, 1.0f);
            this.UI_color3.Set(1.0f, 1.0f, 1.0f, 1.0f);
            this.UI_colorTime1 = 20;
            this.UI_colorTime2 = 60;
            this.UI_colorTime3 = 80;
            this.UI_life = 100;
            this.UI_lifeRnd = 0;
            this.UI_numColorRepeat = 1;
            this.UI_scale1.Set(0, 0);
            this.UI_scale2.Set(1, 1);
            this.UI_scale3.Set(200, 200);
            this.UI_scaleTime1 = 0;
            this.UI_scaleTime2 = 100;
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// ベクトルを設定します
        /// </summary>
        /// <param name="source">設定するベクトルです</param>
        public override void Set(AnimEditData source)
        {
            Ensure.Argument.NotNull(source);

            this.UI_life = source.UI_life;
            this.UI_lifeRnd = source.UI_lifeRnd;

            this.UI_alpha1 = source.UI_alpha1;
            this.UI_alpha2 = source.UI_alpha2;
            this.UI_alpha3 = source.UI_alpha3;
            this.UI_alphaTime1 = source.UI_alphaTime1;
            this.UI_alphaTime2 = source.UI_alphaTime2;

            this.UI_scale1.Set(source.UI_scale1);
            this.UI_scale2.Set(source.UI_scale2);
            this.UI_scale3.Set(source.UI_scale3);
            this.UI_scaleTime1 = source.UI_scaleTime1;
            this.UI_scaleTime2 = source.UI_scaleTime2;

            this.UI_color1.Set(source.UI_color1);
            this.UI_color2.Set(source.UI_color2);
            this.UI_color3.Set(source.UI_color3);
            this.UI_colorTime1 = source.UI_colorTime1;
            this.UI_colorTime2 = source.UI_colorTime2;
            this.UI_colorTime3 = source.UI_colorTime3;
            this.UI_numColorRepeat = source.UI_numColorRepeat;

            this.UI_lifeInfinit = source.UI_lifeInfinit;
        }

        /// <summary>
        /// オブジェクトを複製します。
        /// </summary>
        /// <returns>複製したオブジェクトです。</returns>
        public override AnimEditData Clone()
        {
            return new AnimEditData(this);
        }

        #endregion
    }
}
