﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel
{
    /// <summary>
    /// 揺らぎパラメータ
    /// </summary>
    public sealed class FluctuationData : BaseDataModel<FluctuationData>
    {
        #region Properties

        /// <summary>
        /// 振幅
        /// </summary>
        public float ScaleX { get; set; }

        /// <summary>
        /// 周波数
        /// </summary>
        public int FrequencyX { get; set; }

        /// <summary>
        /// 初期位相
        /// </summary>
        public int InitPhaseX { get; set; }

        /// <summary>
        /// 位相ランダム( 0 or 1 )
        /// </summary>
        public uint PhaseRangeX { get; set; }

        /// <summary>
        /// 振幅
        /// </summary>
        public float ScaleY { get; set; }

        /// <summary>
        /// 周波数
        /// </summary>
        public int FrequencyY { get; set; }

        /// <summary>
        /// 初期位相
        /// </summary>
        public int InitPhaseY { get; set; }

        /// <summary>
        /// 位相ランダム( 0 or 1 )
        /// </summary>
        public uint PhaseRangeY { get; set; }

        #endregion

        #region Construtors

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public FluctuationData()
        {
        }

        /// <summary>
        /// コピーコンストラクタ
        /// </summary>
        /// <param name="source">コピー元のベクトル</param>
        public FluctuationData(FluctuationData source)
            : this()
        {
            this.Set(source);
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            this.ScaleX = 1.0f;
            this.PhaseRangeX = 0;
            this.FrequencyX = 20;
            this.InitPhaseX = 0;
            this.ScaleY = 1.0f;
            this.PhaseRangeY = 0;
            this.FrequencyY = 20;
            this.InitPhaseY = 0;
        }

        /// <summary>
        /// ベクトルを設定します
        /// </summary>
        /// <param name="source">設定するベクトルです</param>
        public override void Set(FluctuationData source)
        {
            Ensure.Argument.NotNull(source);

            this.ScaleX = source.ScaleX;
            this.FrequencyX = source.FrequencyX;
            this.PhaseRangeX = source.PhaseRangeX;
            this.InitPhaseX = source.InitPhaseX;

            this.ScaleY = source.ScaleY;
            this.FrequencyY = source.FrequencyY;
            this.PhaseRangeY = source.PhaseRangeY;
            this.InitPhaseY = source.InitPhaseY;
        }

        /// <summary>
        /// オブジェクトを複製します。
        /// </summary>
        /// <returns>複製したオブジェクトです。</returns>
        public override FluctuationData Clone()
        {
            return new FluctuationData(this);
        }

        #endregion
    }
}
