﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Drawing;

namespace App.Utility
{
    /// <summary>
    /// メモリ描画用グラフィクスクラス。
    /// </summary>
    public sealed class MemoryGraphics : IDisposable
    {
        private Graphics _graphics = null;
        private Bitmap   _bitmap   = null;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public MemoryGraphics(int width, int height)
        {
            _bitmap   = new Bitmap(width, height);
            _graphics = Graphics.FromImage(_bitmap);
        }

        /// <summary>
        /// グラフィクス。
        /// </summary>
        public Graphics Graphics
        {
            get { return _graphics; }
        }

        /// <summary>
        /// ビットマップ。
        /// </summary>
        public Bitmap Bitmap
        {
            get { return _bitmap; }
        }

        /// <summary>
        /// 再作成。
        /// </summary>
        public static bool Recreate(ref MemoryGraphics memGfx, Size size)
        {
            if (size.Width > 0 && size.Height > 0)
            {
                if (memGfx == null || memGfx.Bitmap.Width < size.Width || memGfx.Bitmap.Height < size.Height)
                {
                    if (memGfx != null)
                    {
                        memGfx.Dispose();
                    }
                    memGfx = new MemoryGraphics(size.Width, size.Height);
                    return true;
                }
            }
            return false;
        }

        #region IDisposable実装
        /// <summary>
        /// インタフェース実装。
        /// </summary>
        public void Dispose()
        {
            if (_graphics != null)
            {
                _graphics.Dispose();
                _graphics = null;
            }
            if (_bitmap != null)
            {
                _bitmap.Dispose();
                _bitmap = null;
            }
        }
        #endregion
    }
}
