﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using NintendoWare.ToolDevelopmentKit;

namespace App.Utility
{
    /// <summary>
    /// ドキュメントユーティリティ
    /// </summary>
    public static class DocumentUtility
    {
        #region 命名規則チェック

        /// <summary>
        /// コメント用文字列のチェック
        /// </summary>
        /// <returns>=true..OK</returns>
        public static bool IsValidateCommentString(string comment)
        {
            return RegexMatch.Check(comment, "[^\\uFF61-\\uFF9F\"&'<>]*");
        }

        /// <summary>
        /// エントリー名用文字列のチェック
        /// </summary>
        /// <returns>=true..OK</returns>
        public static bool IsValidateEntryName(string entryName)
        {
            return RegexMatch.Check( entryName, res.Strings.REGEXP_DOCUMENT_NAME_VALIDATION );
        }

        #endregion
    }
}
