﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace App.Utility
{
    /// <summary>
    /// データサイズクラス。
    /// </summary>
    public sealed class DataSize
    {
        private readonly int _bytes;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public DataSize(int bytes)
        {
            _bytes = bytes;
        }

        /// <summary>
        /// バイト数。
        /// </summary>
        public int Bytes
        {
            get { return _bytes; }
        }

        /// <summary>
        /// キロバイト数。
        /// </summary>
        public float KBytes
        {
            get { return _bytes / 1024.0f; }
        }

        /// <summary>
        /// キロバイト数テキスト。
        /// </summary>
        public string KBytesText
        {
            get
            {
                float kb = this.KBytes;
                if (kb < 1.0f) { return string.Format("{0:f2} KB", kb);   }
                else           { return string.Format("{0} KB", (int)kb); }
            }
        }

        /// <summary>
        /// メガバイト数。
        /// </summary>
        public float MBytes
        {
            get { return _bytes / 1024.0f / 1024.0f; }
        }

        /// <summary>
        /// メガバイト数テキスト。
        /// </summary>
        public string MBytesText
        {
            get
            {
                float mb = this.MBytes;
                if (mb < 1.0f) { return string.Format("{0:f2} MB", mb);   }
                else           { return string.Format("{0} MB", (int)mb); }
            }
        }
    }
}
