﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Diagnostics;
using System.Collections.Generic;
using System.IO;
using System.Windows.Forms;
using App.Data;
using App.Utility;

namespace App.IO
{
    /// <summary>
    /// パスリスト。
    /// </summary>
    public sealed class PathList
    {
        // ファイルパスリスト
        private readonly List<string> m_prevList = new List<string>();
        private readonly List<string> m_fenvList = new List<string>();
        private readonly List<string> m_emitterSetList = new List<string>();
        private readonly List<string> m_invalidList = new List<string>();

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public PathList(string[] filePaths)
        {
            // 振り分け
            foreach (string filePath in filePaths)
            {
                if (Directory.Exists(filePath))
                {
                    ClassifyDirectory(filePath);
                }
                else
                {
                    ClassifyFile(filePath);
                }
            }
        }

        /// <summary>
        /// プロジェクトファイルリスト。
        /// </summary>
        public List<string> PreviewFileList { get { return m_prevList; } }

        /// <summary>
        /// プロジェクトファイルリスト。
        /// </summary>
        public List<string> FenvConfigList { get { return m_fenvList; } }

        /// <summary>
        /// パーティクルファイルリスト。
        /// </summary>
        public List<string> EmitterSetList { get { return m_emitterSetList; } }

        /// <summary>
        /// 無効なファイルリスト。
        /// </summary>
        public List<string> InvalidList { get { return m_invalidList; } }


        private void ClassifyDirectory(string directoryPath)
        {
            foreach (string directory in Directory.GetDirectories(directoryPath))
            {
                ClassifyDirectory(directory);
            }
            foreach (string file in Directory.GetFiles(directoryPath))
            {
                ClassifyFile(file);
            }
        }

        private void ClassifyFile(string filePath)
        {
            string fileExt = Path.GetExtension(filePath).ToLower();

            if (DocumentConstants.DotEset == fileExt)
            {
                // パーティクル・ファイル
                m_emitterSetList.Add(filePath);
            }
            else if (DocumentConstants.DotFEnv == fileExt)
            {
                // 環境設定ファイル
                m_fenvList.Add(filePath);
            }
            else if ( DocumentConstants.DotPrev == fileExt )
            {
                // 環境設定ファイル
                m_prevList.Add( filePath );
            }
            else
            {
                // WARNING:未対応の拡張子
                m_invalidList.Add(filePath);
            }
        }
    }
}
