﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
//#define USE_APPDOMAIN
#define USE_PROCESS
//#define PREVIOUS

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading;
using System.Windows.Forms;

namespace App.IO
{
    /// <summary>
    /// クリエイティブスタジオコンソールのクラス
    /// </summary>
    public class CreativeStudio : IDisposable
    {
        const string STR_FRIENDLYNAME = "NW4C_CreativeStudioConsole";
        const string PATH_EXE = @"converter\NW4C_CreativeStudioConsole.exe";
        const string PATH_FOLDER = "converter";  // コンバーターへのパス
        readonly string m_folderPath;
        readonly string m_exePath;
        object m_syncObject;
        static CreativeStudio s_instanse = null;
#if USE_APPDOMAIN
        AppDomain m_appDomain = null;
        AppDomainSetup m_setup;
#endif
        /// <summary>
        /// インスタンスを取得します。
        /// </summary>
        public static CreativeStudio Instanse
        {
            get
            {
                if (s_instanse == null)
                {
                    s_instanse = new CreativeStudio();
                }
                return s_instanse;
            }
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        private CreativeStudio()
        {
            m_syncObject = new Object();
            string folder = Path.GetDirectoryName(Application.ExecutablePath);
            m_folderPath = Path.Combine(folder, PATH_FOLDER);
            m_exePath = Path.Combine(folder, PATH_EXE);
#if PREVIOUS
#if true
            AppDomain.CurrentDomain.AppendPrivatePath(m_folderPath);
#else
            AppDomain.CurrentDomain.SetupInformation.PrivateBinPath = PATH_FOLDER;
#endif
            // 別スレッドで初期化
            var thread = new Thread(new ThreadStart(dummy));
            thread.Start();
#endif
        }

#if USE_APPDOMAIN
        private void dummy()
        {
            string[] dummy = new string[2] { "--auto_create_shader=off", "dummy" };
            lock (m_syncObject)
            {
                m_appDomain.ExecuteAssembly(m_exePath, dummy);
            }
        }
#endif
#if PREVIOUS
        private void dummy()
        {
            string[] dummy =
                new string[2] { "--auto_create_shader=on", "dummy" };
            Main(dummy);
        }
#endif

        /// <summary>
        /// 初期化(コンストラクタを起動)
        /// </summary>
        public void Initialize()
        {
#if USE_APPDOMAIN
            try
            {
                // Setup
                m_setup = new System.AppDomainSetup();
                m_setup.PrivateBinPath = m_folderPath;
                m_setup.ApplicationBase = m_folderPath;
                m_setup.ApplicationName = STR_FRIENDLYNAME;
                m_setup.CachePath = m_folderPath;
                // Evidence
//                System.Security.Policy.Evidence evidence =
//                    new System.Security.Policy.Evidence(AppDomain.CurrentDomain.Evidence);
                // Create AppDomain
                m_appDomain = System.AppDomain.CreateDomain(
                    STR_FRIENDLYNAME, null, m_folderPath, m_folderPath, true);
                // 別スレッドで初期化
                var thread = new Thread(new ThreadStart(dummy));
                thread.Start();
            }
            catch (Exception ex)
            {
                DebugConsole.WriteLine(ex.Message);
            }
#endif
        }

        /// <summary>
        /// 破棄します。
        /// </summary>
        public void Dispose()
        {
#if USE_APPDOMAIN
            if (m_appDomain != null)
            {
                AppDomain.Unload(m_appDomain);
                m_appDomain = null;
            }
#endif
        }

        /// <summary>
        /// CreativeStudio コンソールのMain を呼び出し
        /// </summary>
        public int Main(string[] args)
        {
            if (File.Exists(m_exePath) == false)
            {
                return -1;
            }

            int result = 0;

            lock (m_syncObject)
            {

                // コンバート中のメッセージをステータスバーへ表示します。
                TheApp.MainFrame.StatusMessage =
                    String.Format(res.Strings.STATUS_BINCONVERT_MSG,
                        Path.GetFileNameWithoutExtension(args[args.Length - 1]));
                TheApp.MainFrame.IsEnableNoticeStatusMessage = false;

                try
                {
#if USE_APPDOMAIN
                    int resut = m_appDomain.ExecuteAssembly(m_exePath, args);
                    result = (resut > 0) ? 0 : -1;
#endif

#if USE_PROCESS
                    using (Process process = new Process())
                    {
                        // 情報を設定します。
                        ProcessStartInfo info = new ProcessStartInfo(m_exePath);
                        info.CreateNoWindow = true;
                        info.RedirectStandardError = true;
                        info.RedirectStandardOutput = true;
                        info.UseShellExecute = false;
                        info.WorkingDirectory = m_folderPath;

                        // 引数を設定します。
                        string argInfo = String.Empty;
                        foreach (string arg in args)
                        {
                            argInfo = argInfo + arg + " ";
                        }
                        info.Arguments = argInfo;

                        // プロセス実行
                        process.StartInfo = info;
                        process.Start();
                        process.WaitForExit(process.Id);

                        // ログを取得
                        while (process.StandardOutput.EndOfStream == false)
                        {
                            string line = process.StandardOutput.ReadLine();
                            if (line.IndexOf("ERROR", StringComparison.CurrentCultureIgnoreCase) >= 0)
                            {
                                TheApp.Logger.Error.AddMessage(line);
                            }
                            DebugConsole.WriteLine(line);
                        }

                        // 終了
                        result = (process.ExitCode >= 0) ? 0 : -1;

                        process.Refresh();
                        process.Close();
                    }
#endif

#if PREVIOUS
                    return NintendoWare.CreativeStudio.Program.Main(args);
#endif
                }
                catch (Exception ex)
                {
                    DebugConsole.WriteLine("ERROR " + ex.Message);
                    result = -1;
                }

                // ステータスバー・メッセージを削除します。
                TheApp.MainFrame.IsEnableNoticeStatusMessage = true;
                TheApp.MainFrame.StatusMessage = String.Empty;
            }

            return result;
        }
    }
}
