﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Threading;
using System.Windows.Forms;

namespace App
{
    /// <summary>
    /// デバッグコンソールクラス。
    /// </summary>
    public class DebugConsole
    {
        // インスタンス
        private static NWCore.DebugConsole.DebugConsole s_instance =
            new NWCore.DebugConsole.DebugConsole();

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        private DebugConsole()
        {
        }

        /// <summary>
        /// 初期化処理。
        /// </summary>
        [Conditional("DEBUG")]
        public static void Initialize( NWCore.DebugConsole.IDebugConsoleOwner owner )
        {
            s_instance.Initialize(owner);
        }

        /// <summary>
        /// 終了処理。
        /// </summary>
        [Conditional("DEBUG")]
        public static void Terminate()
        {
            s_instance.Terminate();
        }

        /// <summary>
        /// 書き込み。
        /// </summary>
        [Conditional("DEBUG")]
        public static void Write(string message)
        {
            s_instance.Write(message);
        }

        /// <summary>
        /// 書式指定付き書き込み。
        /// </summary>
        [Conditional("DEBUG")]
        public static void Write(string format, params object[] args)
        {
            Write(string.Format(format, args));
        }

        /// <summary>
        /// 書き込み＋改行。
        /// </summary>
        [Conditional("DEBUG")]
        public static void WriteLine(string message)
        {
            Write(message + "\r\n");
        }

        /// <summary>
        /// 書式指定付き書き込み＋改行。
        /// </summary>
        [Conditional("DEBUG")]
        public static void WriteLine(string format, params object[] args)
        {
            Write(string.Format(format, args) + "\r\n");
        }

        /// <summary>
        /// 条件付き書き込み。
        /// </summary>
        [Conditional("DEBUG")]
        public static void WriteIf(bool condition, string message)
        {
            if (condition)
            {
                Write(message);
            }
        }

        /// <summary>
        /// 条件付き書式指定付き書き込み。
        /// </summary>
        [Conditional("DEBUG")]
        public static void WriteIf(bool condition, string format, params object[] args)
        {
            if (condition)
            {
                Write(format, args);
            }
        }

        /// <summary>
        /// 条件付き書き込み＋改行。
        /// </summary>
        [Conditional("DEBUG")]
        public static void WriteLineIf(bool condition, string message)
        {
            if (condition)
            {
                WriteLine(message);
            }
        }

        /// <summary>
        /// 条件付き書式指定付き書き込み＋改行。
        /// </summary>
        [Conditional("DEBUG")]
        public static void WriteLineIf(bool condition, string format, params object[] args)
        {
            if (condition)
            {
                WriteLine(format, args);
            }
        }
    }
}
