﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using NWCore.DataModel;

namespace App.Data
{
    /// <summary>
    /// プロジェクトパネル用ベースクラスです。
    /// </summary>
    public abstract class BaseProjectPanelDocument : Document
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public BaseProjectPanelDocument(string name)
            : base(name)
        {
            this.IsExpand  = true;
        }

        /// <summary>
        /// ディレクトリパスを指定します。
        /// </summary>
        /// <param name="fileLocation">新しいディレクトリーパスです。</param>
        public override void SetFileLocation(string fileLocation)
        {
            base.SetFileLocation(fileLocation);
        }

        /// <summary>
        /// ツリーが開いているか？
        /// </summary>
        public bool IsExpand
        {
            get;
            set;
        }

        /// <summary>
        /// Get or set the text offset on the project tree node.
        /// </summary>
        public int ProjectTreeNodeTextOffset
        {
            get;
            set;
        }

        /// <summary>
        /// Check if the document can be dragged on project tree view.
        /// </summary>
        /// <returns>True if can be dragged.</returns>
        public virtual bool CanDrag()
        {
            return false;
        }


        /// <summary>
        /// Check if the given document can be dropped and inserted before this document.
        /// </summary>
        /// <param name="doc">The dropped document.</param>
        /// <returns>True if the given document can be dropped.</returns>
        public virtual bool CanDrop( IDocument doc )
        {
            return false;
        }


        /// <summary>
        /// Check if the given document can be added as a child of this document.
        /// E.q. Emitter can be emitter set's child, but cannot be a child
        /// of an effect project document.
        /// </summary>
        /// <param name="doc">The child document.</param>
        /// <returns>True if the given document is a valid child document type.</returns>
        public virtual bool CanAddAsChildDoc( IDocument doc )
        {
            return false;
        }


        /// <summary>
        /// Move the specified child document to the location
        /// before another child document.
        /// </summary>
        /// <param name="doc">The child document to move.</param>
        /// <param name="beforeDoc">
        /// The child document which "doc" will be moved before,
        /// null to move "doc" to the last child document.
        /// </param>
        /// <returns>The document after moved.</returns>
        public virtual IDocument MoveChildDocument( IDocument doc,
                                                    IDocument beforeDoc )
        {
            return null;
        }
    }

}
