﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;

using EffectMaker.DataModelMaker.Core.Core;
using EffectMaker.DataModelMaker.Core.DataTypes;
using EffectMaker.DataModelMaker.Core.Definitions;

using EffectMaker.Foundation.Dynamic;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.Foundation.Log;

namespace EffectMaker.DataModelMaker.UILogic.ViewModels
{
    /// <summary>
    /// View model class for the binary field group targets.
    /// </summary>
    public class BinaryFieldGroupTargetItemViewModel : ViewModelBase
    {
        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public BinaryFieldGroupTargetItemViewModel(
            ViewModelBase parent,
            DefinitionBase dataModel) :
            base(parent, dataModel)
        {
        }

        /// <summary>
        /// Get the name of the binary field group target.
        /// </summary>
        public string TargetName
        {
            get
            {
                string name = string.Empty;
                if (this.DataModel is BinaryDataDefinition)
                {
                    return ((BinaryDataDefinition)this.DataModel).Name;
                }
                else if (this.DataModel is RuntimeDataModelDefinition)
                {
                    bool typeExists = TypeManager.ComposeRuntimeTypeFullName(
                        ((RuntimeDataModelDefinition)this.DataModel).Namespace,
                        ((RuntimeDataModelDefinition)this.DataModel).Name,
                        out name);
                }

                return name;
            }
        }

        /// <summary>
        /// Get the flag indicating whether the target is a binary data or not.
        /// </summary>
        public bool IsTargetBinaryData
        {
            get
            {
                if (this.DataModel is BinaryDataDefinition)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
        }
    }
}
