﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using EffectMaker.UIControls;
using EffectMaker.UIControls.DataBinding;
using EffectMaker.UIControls.Extenders;

namespace EffectMaker.DataModelMaker.UIControls.DataModelView.Editor
{
    /// <summary>
    /// Renderable viewport class for the editor data model list.
    /// </summary>
    internal class EditorDataModelListRenderable : DataModelListViewport
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="renderingControl">The control to be rendered to.</param>
        public EditorDataModelListRenderable(Control renderingControl) :
            base(renderingControl)
        {
            // Set up binding.
            this.Bindings.Add(new Binder(this, "DataModelListSource", "DataModelDefinitionViewModels"));
        }

        /// <summary>
        /// Create list item renderable from the specified source.
        /// </summary>
        /// <param name="itemSource">The list item data source.</param>
        /// <returns>The created list item renderable.</returns>
        protected override DataModelListItemRenderable CreateItemRenderable(object itemSource)
        {
            // Create the item.
            var renderable = new EditorDataModelListItemRenderable(this);

            // Setup the data context for the created item.
            renderable.DataContext = itemSource;

            return renderable;
        }
    }
}
