﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Windows.Forms;

using EffectMaker.DataModelMaker.UIControls.Interfaces;

using EffectMaker.DataModelMaker.UILogic.ViewModels;

using EffectMaker.UIControls.Layout;

namespace EffectMaker.DataModelMaker.UIControls.DataModelEditor
{
    /// <summary>
    /// Dialog for creating data model definition.
    /// </summary>
    public partial class DataModelEditorDialog : Form
    {
        /// <summary>The data model editor panel.</summary>
        private IDataModelEditor dataModelEditorPanel = null;

        /// <summary>
        /// Constructor.
        /// </summary>
        public DataModelEditorDialog()
        {
            this.InitializeComponent();
        }

        /// <summary>
        /// Get or set the flag indicating whether should delete the data source if the editing
        /// is canceled.
        /// </summary>
        public bool ShouldDeleteDataSourceOnCancel { get; set; }

        /// <summary>
        /// Get or set the data source for the editor.
        /// </summary>
        public object DataSource
        {
            get
            {
                if (this.dataModelEditorPanel == null)
                {
                    return null;
                }

                return this.dataModelEditorPanel.DataContext;
            }

            set
            {
                if (value == null)
                {
                    return;
                }

                if (value is EditorDataModelDefinitionViewModel)
                {
                    var editor = new EditorDataModelEditor();

                    this.mainTableLayout.Controls.Add(editor, 0, 0);
                    this.mainTableLayout.SetColumnSpan(editor, 3);

                    editor.Dock = DockStyle.Fill;
                    editor.Visibility = Visibility.Visible;

                    editor.DataContext = value;

                    this.dataModelEditorPanel = editor;
                }
                else if (value is RuntimeDataModelDefinitionViewModel)
                {
                    var editor = new RuntimeDataModelEditor();

                    this.mainTableLayout.Controls.Add(editor, 0, 0);
                    this.mainTableLayout.SetColumnSpan(editor, 3);

                    editor.Dock = DockStyle.Fill;
                    editor.Visibility = Visibility.Visible;

                    editor.DataContext = value;

                    this.dataModelEditorPanel = editor;
                }
                else
                {
                    return;
                }
            }
        }

        /// <summary>
        /// Handle FormClosing event.
        /// </summary>
        /// <param name="e">The event arguments.</param>
        protected override void OnFormClosing(FormClosingEventArgs e)
        {
            if (this.DialogResult == DialogResult.OK)
            {
                if (this.dataModelEditorPanel.CommitEditing() == false)
                {
                    e.Cancel = true;
                }
            }
            else
            {
                this.dataModelEditorPanel.CancelEditing(this.ShouldDeleteDataSourceOnCancel);
            }

            base.OnFormClosing(e);
        }
    }
}
