﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Drawing;
using System.Windows.Forms;

using EffectMaker.DataModelMaker.UIControls.DataModelEditor;
using EffectMaker.DataModelMaker.UIControls.DataModelPropertyEditor;

using EffectMaker.Foundation.Render.ObjectPicking;
using EffectMaker.Foundation.Render.Renderable;
using EffectMaker.Foundation.Render.ScrollBar;

using EffectMaker.UIControls.BaseControls;

namespace EffectMaker.DataModelMaker.UIControls.ConversionView
{
    /// <summary>
    /// Control class for rendering the data model relation view.
    /// </summary>
    public partial class ConversionView : UserControl
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        public ConversionView()
        {
            // Enable double buffer.
            this.DoubleBuffered = true;
            this.BackColor = Color.White;

            this.InitializeComponent();
        }

        /// <summary>
        /// Event triggered when split panel splitter moved.
        /// </summary>
        public event SplitterEventHandler SplitterMoved = null;

        /// <summary>
        /// Get or set the splitter distance of the split panel.
        /// </summary>
        public int SplitterDistance
        {
            get { return this.mainSplitPanel.SplitterDistance; }
            set { this.mainSplitPanel.SplitterDistance = value; }
        }

        /// <summary>
        /// Get or set the data context.
        /// </summary>
        public object DataContext
        {
            get
            {
                return this.conversionViewPanel.DataContext;
            }

            set
            {
                this.binaryDataListPanel.DataContext = value;
                this.conversionViewPanel.DataContext = value;
            }
        }

        /// <summary>
        /// Handle SplitterMoved event for the split panel.
        /// </summary>
        /// <param name="sender">The sender of the event.</param>
        /// <param name="e">The event arguments.</param>
        private void OnSplitterMoved(object sender, SplitterEventArgs e)
        {
            if (this.SplitterMoved != null)
            {
                this.SplitterMoved(this, e);
            }
        }
    }
}
