﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Windows.Forms;

using EffectMaker.DataModelMaker.UIControls.Interfaces;

using EffectMaker.DataModelMaker.UILogic.ViewModels;

using EffectMaker.UIControls.Layout;

namespace EffectMaker.DataModelMaker.UIControls.BinaryDataEditor
{
    /// <summary>
    /// Dialog for creating data model definition.
    /// </summary>
    public partial class BinaryDataEditorDialog : Form
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        public BinaryDataEditorDialog()
        {
            this.InitializeComponent();
        }

        /// <summary>
        /// Get or set the flag indicating whether should delete the data source if the editing
        /// is canceled.
        /// </summary>
        public bool ShouldDeleteDataSourceOnCancel { get; set; }

        /// <summary>
        /// Get or set the data source for the editor.
        /// </summary>
        public object DataSource
        {
            get { return this.binaryDataEditorPanel.DataContext; }
            set { this.binaryDataEditorPanel.DataContext = value; }
        }

        /// <summary>
        /// Handle FormClosing event.
        /// </summary>
        /// <param name="e">The event arguments.</param>
        protected override void OnFormClosing(FormClosingEventArgs e)
        {
            if (this.DialogResult == DialogResult.OK)
            {
                if (this.binaryDataEditorPanel.CommitEditing() == false)
                {
                    e.Cancel = true;
                }
            }
            else
            {
                this.binaryDataEditorPanel.CancelEditing(this.ShouldDeleteDataSourceOnCancel);
            }

            base.OnFormClosing(e);
        }
    }
}
