﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace EffectMaker.DataModelMaker.Core.Writers
{
    /// <summary>
    /// base class for source code writers.
    /// </summary>
    public class SourceCodeWriterBase
    {
        /// <summary>
        /// Strings evaluated from the template and data model definitions.
        /// </summary>
        internal string[] EvaluatedTokens { get; set; }

        /// <summary>
        /// Evaluate the actual text represented by the template tokens.
        /// </summary>
        /// <param name="def">The definition.</param>
        /// <returns>The total length of the evaluated text.</returns>
        internal virtual int EvaluateTemplateTokens(object def)
        {
            return 0;
        }

        /// <summary>
        /// Generate source code string from definition.
        /// </summary>
        /// <param name="builder">The string builder to write to.</param>
        /// <returns>True on success.</returns>
        internal bool Write(StringBuilder builder)
        {
            if (this.EvaluatedTokens == null)
            {
                return false;
            }

            foreach (string token in this.EvaluatedTokens)
            {
                if (string.IsNullOrEmpty(token) == false)
                {
                    builder.Append(token);
                }
            }

            return true;
        }

        /// <summary>
        /// Write entry list with the given writers.
        /// </summary>
        /// <param name="builder">The string builder.</param>
        /// <param name="writers">The writers.</param>
        /// <returns>True on success.</returns>
        protected bool WriteEntryList(
            StringBuilder builder,
            List<SourceCodeWriterBase> writers)
        {
            foreach (var writer in writers)
            {
                if (writer.Write(builder) == false)
                {
                    return false;
                }
            }

            return true;
        }
    }
}
