﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace EffectMaker.DataModelMaker.Core
{
    /// <summary>
    /// パケットのためのカスタムアトリビュートです.
    /// </summary>
    [AttributeUsage(AttributeTargets.All, AllowMultiple = false, Inherited = false)]
    public class PacketAttribute : System.Attribute
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        /// <param name="assetID">アセットIDです.</param>
        /// <param name="binaryTag">バイナリタグ名です.</param>
        public PacketAttribute(int assetID, string binaryTag)
        {
            this.AssetID = assetID;
            this.BinaryTag = binaryTag;
        }

        /// <summary>
        /// アセットIDを取得します.
        /// </summary>
        public int AssetID { get; private set; }

        /// <summary>
        /// バイナリタグを取得します.
        /// </summary>
        public string BinaryTag { get; private set; }
    }
}
