﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

using EffectMaker.DataModelMaker.Core.Definitions;

namespace EffectMaker.DataModelMaker.Core
{
    /// <summary>
    /// ジェネレータのインタフェースです.
    /// </summary>
    public interface IGenerator
    {
        /// <summary>
        /// Event triggered when the generation progress is advanced.
        /// </summary>
        event EventHandler ProgressAdvanced;

        /// <summary>
        /// Evaluate total step count for Generate().
        /// </summary>
        /// <returns>The total stap count.</returns>
        int EvaluateTotalProgressSteps();

        /// <summary>
        /// 定義ファイルをロードします.
        /// </summary>
        /// <param name="filename">ロードする定義ファイル名です.</param>
        /// <returns>ロードに成功したらtrueを返却します.</returns>
        bool LoadDefinitionFile(string filename);

        /// <summary>
        /// 定義ファイルをセーブします.
        /// </summary>
        /// <param name="filename">セーブする定義ファイル名です.</param>
        /// <returns>セーブに成功したらtrueを返却します.</returns>
        bool SaveDefinitionFile(string filename);

        /// <summary>
        /// コードを生成します.
        /// </summary>
        /// <param name="path">出力フォルダパスです.</param>
        /// <returns>コード生成に成功したらtrueを返却します.</returns>
        bool Generate(string path);

        /// <summary>
        /// 定義データを取得します.
        /// </summary>
        /// <returns>定義データを返却します.</returns>
        DefinitionBase GetDefinitionData();
    }
}
