﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using System.Linq;

using EffectMaker.DataModelMaker.Core.Core;

namespace EffectMaker.DataModelMaker.Core.CommonData
{
    /// <summary>
    /// Data class of a versioned item data.
    /// </summary>
    public class VersionedItemData
    {
        /// <summary>The list of the child items.</summary>
        private List<VersionedItemData> children = null;

        /// <summary>
        /// Constructor.
        /// </summary>
        public VersionedItemData()
        {
            this.Name = string.Empty;
            this.VersionAction = VersionActions.None;
        }

        /// <summary>
        /// The name of the item.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// The action took on the item at the version.
        /// </summary>
        public VersionActions VersionAction { get; set; }

        /// <summary>
        /// Enumerate all the child items.
        /// </summary>
        public IEnumerable<VersionedItemData> Children
        {
            get
            {
                if (this.children == null)
                {
                    return Enumerable.Empty<VersionedItemData>();
                }

                return this.children;
            }
        }

        /// <summary>
        /// Add a child item.
        /// </summary>
        /// <param name="child">The child item.</param>
        public void AddChild(VersionedItemData child)
        {
            if (this.children == null)
            {
                this.children = new List<VersionedItemData>();
            }

            this.children.Add(child);
        }

        /// <summary>
        /// Remove all the children.
        /// </summary>
        public void RemoveAllChildren()
        {
            this.children = null;
        }
    }
}
