﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.DataModelMaker.Application.CommandLine
{
    /// <summary>
    /// Command-line processor for assigning silent mode.
    /// (The console window will not be created or attached.)
    /// </summary>
    public class SilentModeProcessor : ICommandLineProcessor
    {
        /// <summary>
        /// Enumerates command descriptions.
        /// Each command description consists of a KeyValuePair with
        /// the key as the command keyword, and the value as the description
        /// of the command.
        /// </summary>
        /// <returns>The command descriptions.</returns>
        public IEnumerable<KeyValuePair<string, string>> GetCommandDescriptions()
        {
            yield return new KeyValuePair<string, string>("s", "Enable silent mode.");
        }

        /// <summary>
        /// Set command arguments.
        /// </summary>
        /// <param name="command">The command.</param>
        /// <param name="arguments">The arguments of the command.</param>
        /// <returns>True if the command arguments are valid; otherwise, false is returned.</returns>
        public bool SetCommandArguments(string command, List<string> arguments)
        {
            return true;
        }

        /// <summary>
        /// Execute the commands.
        /// </summary>
        /// <returns>True on success.</returns>
        public bool Execute()
        {
            return true;
        }
    }
}
