﻿// ========================================================================
// <copyright file="InstantDebugUtility.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit
{
    using System.IO;
    using System.Text;

    /// <summary>
    /// 即席のデバッグユーティリティです。
    /// </summary>
    public static class InstantDebugUtility
    {
        private const string FilePath = "temporary_log.txt";
        private const string EncodeName = "shift_jis";

        /// <summary>
        /// ファイルにメッセージを追加出力します。
        /// ファイルが存在しない場合、作成します。
        /// </summary>
        /// <param name="message">出力するメッセージです。</param>
        public static void FileWriteLine(string message)
        {
            Encoding enc = Encoding.GetEncoding(EncodeName);
            File.AppendAllText(FilePath, message + "\n", enc);
        }

        /// <summary>
        /// ファイルの中身をクリアします。
        /// ファイルが存在しない場合、作成します。
        /// </summary>
        public static void FileClear()
        {
            Encoding enc = Encoding.GetEncoding(EncodeName);
            File.WriteAllText(FilePath, string.Empty, enc);
        }
    }
}
