﻿// ========================================================================
// <copyright file="IUserDataOwner.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;

    /// <summary>
    /// ユーザデータの所有者を表すインターフェースです。
    /// </summary>
    public interface IUserDataOwner : INotifyPropertyChanged, ICloneable, ISettable
    {
        /// <summary>
        /// ユーザーデータのリストを取得します。
        /// </summary>
        IList<IMetaData> UserData { get; set; }
    }
}
