﻿// ========================================================================
// <copyright file="IHsvaColor.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit
{
    using System;
    using System.ComponentModel;

    /// <summary>
    /// HSVA 成分を保持するカラーのインターフェースです。
    /// </summary>
    public interface IHsvaColor : IColor, INotifyPropertyChanged
    {
        /// <summary>
        /// H 成分を取得または設定します。
        /// </summary>
        new float H { get; set; }

        /// <summary>
        /// S 成分を取得または設定します。
        /// </summary>
        new float S { get; set; }

        /// <summary>
        /// V 成分を取得または設定します。
        /// </summary>
        new float V { get; set; }

        /// <summary>
        /// 値を設定します。
        /// </summary>
        /// <param name="h">h 成分です。</param>
        /// <param name="s">s 成分です。</param>
        /// <param name="v">v 成分です。</param>
        /// <param name="a">a 成分です。</param>
        void Set(float h, float s, float v, float a);

        /// <summary>
        /// 値を設定します。
        /// </summary>
        /// <param name="source">設定する値です。</param>
        void Set(IHsvaColor source);

        /// <summary>
        /// IRgbaColor を取得します。
        /// </summary>
        /// <returns>RgbaColor です。</returns>
        IRgbaColor ToRgbaColor();
    }
}
