﻿// ========================================================================
// <copyright file="BoundingVolume.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;

    /// <summary>
    /// BoundingVolume のベースクラスです。
    /// </summary>
    public abstract class BoundingVolume : IBoundingVolume
    {
        //-----------------------------------------------------------------
        // コンストラクタ
        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public BoundingVolume()
        {
        }

        /// <summary>
        /// コピーコンストラクタです。
        /// </summary>
        /// <param name="boundingVolume">コピー元のバウンディング情報です。</param>
        private BoundingVolume(BoundingVolume boundingVolume)
            : this()
        {
            this.Set(boundingVolume);
        }

        //-----------------------------------------------------------------
        // クローン、コピー
        //-----------------------------------------------------------------

        /// <summary>
        /// 現在のインスタンスのコピーである新しいオブジェクトを作成します。
        /// </summary>
        /// <returns>このインスタンスのコピーである新しいオブジェクトです。</returns>
        public abstract object Clone();

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        public virtual void Set(object source)
        {
            this.Set(source as BoundingVolume);
        }

        /// <summary>
        /// フラグメントオペレーションを設定します。
        /// </summary>
        /// <param name="source">設定するフラグメントオペレーションです。</param>
        protected void Set(BoundingVolume source)
        {
            Ensure.Argument.NotNull(source);
        }
    }
}
