﻿// ========================================================================
// <copyright file="AxisAlignedBoundingBoxUtility.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;

    /// <summary>
    /// AABBユーティリティです。
    /// </summary>
    public static class AxisAlignedBoundingBoxUtility
    {
        /// <summary>
        /// 2 つの AABB を包含する AABB を生成します。
        /// </summary>
        /// <param name="a">AABB1です。</param>
        /// <param name="b">AABB2です。</param>
        /// <returns>新しく生成されたAABBです。</returns>
        public static AxisAlignedBoundingBox Merge(AxisAlignedBoundingBox a, AxisAlignedBoundingBox b)
        {
            // ２つのAABBの頂点座標を求めます
            List<Vector3> positions = new List<Vector3>();
            foreach (Vector3 position in a.VertexPositions)
            {
                positions.Add(position);
            }

            foreach (Vector3 position in b.VertexPositions)
            {
                positions.Add(position);
            }

            // 求めた座標からAABBを生成します
            AxisAlignedBoundingBox aabb = new AxisAlignedBoundingBox();
            aabb.Set(positions);

            return aabb;
        }
    }
}
