﻿// ========================================================================
// <copyright file="StringArrayMetaData.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit
{
    /// <summary>
    /// 文字列型の属性情報のエンコーディング形式の定義です。
    /// </summary>
    public enum StringMetaDataEncoding
    {
        /// <summary>アスキー形式です。</summary>
        Ascii,

        /// <summary>UTF8形式です。</summary>
        Utf8,

        /// <summary>UTF16リトルエンディアン形式です。</summary>
        Utf16LittleEndian,

        /// <summary>UTF16ビックエンディアン形式です。</summary>
        Utf16BigEndian
    }

    /// <summary>
    /// データに関する文字列配列型属性情報を表すためのクラスです。
    /// </summary>
    public class StringArrayMetaData : ArrayMetaData<string>
    {
        private static readonly StringMetaDataEncoding DefaultBinarizeEncoding = StringMetaDataEncoding.Utf16LittleEndian;
        private StringMetaDataEncoding binarizeEncoding = DefaultBinarizeEncoding;

        //-----------------------------------------------------------------
        // コンストラクタ
        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public StringArrayMetaData()
        {
        }

        /// <summary>
        /// コピーコンストラクタです。
        /// </summary>
        /// <param name="arrayMetaData">コピー元です。</param>
        private StringArrayMetaData(StringArrayMetaData arrayMetaData)
        {
            this.Set(arrayMetaData);
        }

        //-----------------------------------------------------------------
        // プロパティ
        //-----------------------------------------------------------------

        /// <summary>
        /// バイナリ化時のエンコーディング形式を取得または設定します。
        /// </summary>
        public StringMetaDataEncoding BinarizeEncoding
        {
            get
            {
                return this.binarizeEncoding;
            }

            set
            {
                this.binarizeEncoding = value;
                OnPropertyChanged("BinarizeEncoding");
            }
        }

        //-----------------------------------------------------------------
        // メソッド
        //-----------------------------------------------------------------

        /// <summary>
        /// 現在のインスタンスのコピーである新しいオブジェクトを作成します。
        /// </summary>
        /// <returns>このインスタンスのコピーである新しいオブジェクトです。</returns>
        public override object Clone()
        {
            return new StringArrayMetaData(this);
        }
    }
}
