﻿// ========================================================================
// <copyright file="FloatArrayMetaData.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit
{
    /// <summary>
    /// データに関する実数配列型属性情報を表すためのクラスです。
    /// </summary>
    public class FloatArrayMetaData : ArrayMetaData<float>
    {
        //-----------------------------------------------------------------
        // コンストラクタ
        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public FloatArrayMetaData()
        {
        }

        /// <summary>
        /// コピーコンストラクタです。
        /// </summary>
        /// <param name="arrayMetaData">コピー元です。</param>
        private FloatArrayMetaData(FloatArrayMetaData arrayMetaData)
        {
            this.Set(arrayMetaData);
        }

        //-----------------------------------------------------------------
        // メソッド
        //-----------------------------------------------------------------

        /// <summary>
        /// 現在のインスタンスのコピーである新しいオブジェクトを作成します。
        /// </summary>
        /// <returns>このインスタンスのコピーである新しいオブジェクトです。</returns>
        public override object Clone()
        {
            return new FloatArrayMetaData(this);
        }
    }
}
