﻿// ========================================================================
// <copyright file="Matrix34Xml.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Xml
{
    using NintendoWare.ToolDevelopmentKit.Conversion;

    /// <summary>
    /// 3 × 4 行列を表します。
    /// <remarks>
    /// バージョンアップデートの実装と同時に、
    /// 各プロパティに[XmlAttribute]を付加します。
    /// 現状は、アクションでのみ利用されているため保留しています。
    /// </remarks>
    /// </summary>
    [CoupledType(typeof(Matrix34))]
    public class Matrix34Xml : ISettable
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public Matrix34Xml()
        {
        }

        /// <summary>行列の成分を取得または設定します。</summary>
        public float M00 { get; set; }

        /// <summary>行列の成分を取得または設定します。</summary>
        public float M01 { get; set; }

        /// <summary>行列の成分を取得または設定します。</summary>
        public float M02 { get; set; }

        /// <summary>行列の成分を取得または設定します。</summary>
        public float M03 { get; set; }

        /// <summary>行列の成分を取得または設定します。</summary>
        public float M10 { get; set; }

        /// <summary>行列の成分を取得または設定します。</summary>
        public float M11 { get; set; }

        /// <summary>行列の成分を取得または設定します。</summary>
        public float M12 { get; set; }

        /// <summary>行列の成分を取得または設定します。</summary>
        public float M13 { get; set; }

        /// <summary>行列の成分を取得または設定します。</summary>
        public float M20 { get; set; }

        /// <summary>行列の成分を取得または設定します。</summary>
        public float M21 { get; set; }

        /// <summary>行列の成分を取得または設定します。</summary>
        public float M22 { get; set; }

        /// <summary>行列の成分を取得または設定します。</summary>
        public float M23 { get; set; }

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        public void Set(object source)
        {
            this.Set(source as Matrix34Xml);
        }

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        protected void Set(Matrix34Xml source)
        {
            Ensure.Argument.NotNull(source);

            this.M00 = source.M00;
            this.M01 = source.M01;
            this.M02 = source.M02;
            this.M03 = source.M03;

            this.M10 = source.M10;
            this.M11 = source.M11;
            this.M12 = source.M12;
            this.M13 = source.M13;

            this.M20 = source.M20;
            this.M21 = source.M21;
            this.M22 = source.M22;
            this.M23 = source.M23;
        }
    }
}
