﻿// ========================================================================
// <copyright file="GenericMetaDataXml.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Xml
{
    using System.Xml.Serialization;
    using NintendoWare.ToolDevelopmentKit.Conversion;

    /// <summary>
    /// 任意のクラスのインスタンスを1つ保有するメタデータです。
    /// 保有するインスタンスは、GenericMetaDataValueXmlを継承している必要があります。
    /// </summary>
    [CoupledType(typeof(GenericMetaData))]
    [XmlType("GenericMetaData")]
    public sealed class GenericMetaDataXml : EditMetaDataXml
    {
        /// <summary>
        /// 保有するインスタンスです。
        /// </summary>
        [GenerateXmlAttributeOverrides]
        public GenericMetaDataValueXml Value { get; set; }

        /// <summary>
        /// オブジェクトの複製を作成します。
        /// </summary>
        /// <returns>
        /// オブジェクトの複製です。
        /// </returns>
        public override object Clone()
        {
            var newInstance = new GenericMetaDataXml();
            newInstance.Set(this);
            return newInstance;
        }

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        public override void Set(object source)
        {
            this.Set(source as GenericMetaDataXml);
        }

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        private void Set(GenericMetaDataXml source)
        {
            this.Key = source.Key;

            // TODO: shallow copy で問題ないか？
            this.Value = source.Value;
        }
    }
}
