﻿// ========================================================================
// <copyright file="ArrayMetaDataXml.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Xml
{
    /// <summary>
    /// ユーザデータの種類です。
    /// </summary>
    public enum MetaDataKind
    {
        /// <summary>
        /// 不明な型です。
        /// </summary>
        None,

        /// <summary>
        /// 整数です。
        /// </summary>
        IntSet,

        /// <summary>
        /// 浮動少数です。
        /// </summary>
        FloatSet,

        /// <summary>
        /// 文字列です。
        /// </summary>
        StringSet,

        /// <summary>
        /// RGBAです。
        /// </summary>
        ColorSet,

        /// <summary>
        /// Vector3です。
        /// </summary>
        Vector3Set
    }

    /// <summary>
    /// シェーダーに設定するパラメータを管理するためのクラスです。
    /// </summary>
    public class ArrayMetaDataXml
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public ArrayMetaDataXml()
        {
        }

        /// <summary>
        /// データを検索する際のキーワードです。
        /// </summary>
        public virtual string Key { get; set; }

        /// <summary>
        /// 等値であるかどうか比較します。
        /// </summary>
        /// <param name="other">比較対象です。</param>
        /// <returns>等値であれば true を返します。</returns>
        public override bool Equals(object other)
        {
            return this.GetHashCode().Equals(other.GetHashCode());
        }

        /// <summary>
        /// ハッシュ値を取得します。
        /// </summary>
        /// <returns>ハッシュ値です。</returns>
        public override int GetHashCode()
        {
            return HashCalculationUtility.TryGetHashCode(this.Key);
        }
    }
}
