﻿// ========================================================================
// <copyright file="LogLocationTemplate.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Logs
{
    /// <summary>
    /// ログ出力位置のテンプレートです。
    /// </summary>
    /// <typeparam name="TLocation">出力位置のテンプレート型です。</typeparam>
    public abstract class LogLocationTemplate<TLocation> :
        LogLocation, ILogLocationTemplate<TLocation>
    {
        //-----------------------------------------------------------------
        private TLocation location;

        //-----------------------------------------------------------------
        // オブジェクトの生成
        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="location">ログ出力位置のテンプレート型です。</param>
        public LogLocationTemplate(TLocation location)
        {
            this.Location = location;
        }

        //-----------------------------------------------------------------
        // プロパティの取得または設定
        //-----------------------------------------------------------------

        /// <summary>
        /// 出力位置を取得または設定します。
        /// </summary>
        public TLocation Location
        {
            get
            {
                return this.location;
            }

            set
            {
                Ensure.Argument.NotNull(value);

                this.location = value;
                OnPropertyChanged("Location");
            }
        }

        //-----------------------------------------------------------------
        // 同値比較
        //-----------------------------------------------------------------

        /// <summary>
        /// 等値であるかどうか比較します。
        /// </summary>
        /// <param name="other">比較対象です。</param>
        /// <returns>等値であれば true を返します。</returns>
        public override bool Equals(object other)
        {
            if (other == this)
            {
                return true;
            }

            if ((other == null) || (other.GetType() != GetType()))
            {
                return false;
            }

            return this.Equals(other as LogLocationTemplate<TLocation>);
        }

        /// <summary>
        /// ハッシュ値を取得します。
        /// </summary>
        /// <returns>ハッシュ値です。</returns>
        public override int GetHashCode()
        {
            return this.Location.GetHashCode();
        }

        /// <summary>
        /// 等値であるかどうか比較します。
        /// </summary>
        /// <param name="other">比較対象です。</param>
        /// <returns>等値であれば true を返します。</returns>
        protected bool Equals(LogLocationTemplate<TLocation> other)
        {
            Ensure.Argument.NotNull(other);
            return this.Location.Equals(other.Location);
        }
    }
}
