﻿// ========================================================================
// <copyright file="NamedProperty.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Conversion
{
    using System.Reflection;

    /// <summary>
    /// インスタンスを共有する型に指定するアトリビュートです。
    /// </summary>
    public class NamedProperty
    {
        private readonly string name;
        private object targetObject;
        private PropertyInfo propertyInfo;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="name">名前です。</param>
        /// <param name="propertyInfo">プロパティ情報です。</param>
        public NamedProperty(string name, PropertyInfo propertyInfo)
        {
            this.name = name;
            this.propertyInfo = propertyInfo;
        }

        /// <summary>
        /// 名前です。
        /// </summary>
        public string Name
        {
            get
            {
                return this.name;
            }
        }

        /// <summary>
        /// 対象インスタンスです。
        /// </summary>
        public object TargetObject
        {
            get
            {
                return this.targetObject;
            }

            set
            {
                this.targetObject = value;
            }
        }

        /// <summary>
        /// プロパティ情報です。
        /// </summary>
        public PropertyInfo PropertyInfo
        {
            get { return this.propertyInfo; }
            set { this.propertyInfo = value; }
        }

        /// <summary>
        /// プロパティ値を取得します。
        /// </summary>
        public object PropertyValue
        {
            get
            {
                Ensure.Operation.ObjectNotNull(this.PropertyInfo);
                Ensure.Operation.ObjectNotNull(this.TargetObject);

                return this.PropertyInfo.GetValue(this.TargetObject, null);
            }
        }

        /// <summary>
        /// 任意の目的に利用できる、拡張データです。
        /// </summary>
        public object ExtraData { get; set; }
    }
}
