﻿// ========================================================================
// <copyright file="CoupledTypeTargetOptionsAttribute.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Conversion
{
    using System;

    /// <summary>
    /// 型の関連付け記述オプションをあらわすアトリビュートです。
    /// </summary>
    public class CoupledTypeTargetOptionsAttribute : Attribute
    {
        private Type targetType;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="targetType">関連付けられた型です。</param>
        public CoupledTypeTargetOptionsAttribute(Type targetType)
        {
            this.targetType = targetType;
        }

        /// <summary>
        /// 関連付けられた型を取得、設定します。
        /// </summary>
        public Type TargetType
        {
            get
            {
                return this.targetType;
            }

            set
            {
                Ensure.Argument.NotNull(value);
                this.targetType = value;
            }
        }
    }
}
