﻿// ========================================================================
// <copyright file="ObservableChildObject.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.ComponentModel
{
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// 通知機能のついた親を持つオブジェクトです。
    /// </summary>
    /// <typeparam name="TParent">親のテンプレート型です。</typeparam>
    public class ObservableChildObject<TParent> : ObservableObject, IChildObject<TParent>
        where TParent : class
    {
        //-----------------------------------------------------------------
        private TParent parent = null;

        /// <summary>
        /// 親を取得または設定します。
        /// 親を再設定する場合、一度 null を設定してクリアしてください。
        /// </summary>
        public virtual TParent Parent
        {
            get
            {
                return this.parent;
            }

            set
            {
                if (this.parent == value)
                {
                    return;
                }

                Ensure.Operation.True((this.parent == null) || (value == null));

                this.parent = value;
                OnPropertyChanged("Parent");
            }
        }

        /// <summary>
        /// 親を取得または設定します。
        /// 親を再設定する場合、一度 null を設定してクリアしてください。
        /// </summary>
        object IChildObject.Parent
        {
            get { return this.Parent; }
            set { this.Parent = value as TParent; }
        }
    }
}
