﻿// ========================================================================
// <copyright file="InstanceListDecorator.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================
namespace NintendoWare.ToolDevelopmentKit.Collections
{
    using System.Collections.Generic;

    /// <summary>
    /// null を許容しない、インスタンスを保持するためのリストデコレータです。
    /// </summary>
    /// <typeparam name="TItem">要素のテンプレート型です。</typeparam>
    public class InstanceListDecorator<TItem> : ListDecorator<TItem>
        where TItem : class
    {
        //-----------------------------------------------------------------
        // オブジェクトの生成
        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="list">デコレーションするリストです。</param>
        public InstanceListDecorator(IList<TItem> list)
            : base(list)
        {
        }

        //-----------------------------------------------------------------
        // 要素の取得または設定
        //-----------------------------------------------------------------

        /// <summary>
        /// 指定したインデックス位置へのアクセスを行うインデクサです。
        /// </summary>
        /// <param name="index">アクセスする項目の 0 から始まるインデックスです。</param>
        /// <returns>インデックス位置の項目です。</returns>
        public override TItem this[int index]
        {
            set
            {
                Ensure.Argument.NotNull(value);

                base[index] = value;
            }
        }

        //-----------------------------------------------------------------
        // 要素の追加または削除
        //-----------------------------------------------------------------

        /// <summary>
        /// 指定したインデックス位置に項目を挿入します。
        /// </summary>
        /// <param name="index">項目を挿入する位置の、0 から始まるインデックス番号です。</param>
        /// <param name="item">挿入する項目です。</param>
        public override void Insert(int index, TItem item)
        {
            Ensure.Argument.NotNull(item);

            base.Insert(index, item);
        }
    }
}
