﻿// ========================================================================
// <copyright file="InstanceDictionaryDecorator.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================
namespace NintendoWare.ToolDevelopmentKit.Collections
{
    using System.Collections.Generic;

    /// <summary>
    /// null を許容しない、インスタンスを保持するためのディクショナリーデコレータです。
    /// </summary>
    /// <typeparam name="TKey">ディクショナリー内のキーのテンプレート型です。</typeparam>
    /// <typeparam name="TValue">ディクショナリー内の値のテンプレート型です。</typeparam>
    public class InstanceDictionaryDecorator<TKey, TValue> : DictionaryDecorator<TKey, TValue>
    {
        //-----------------------------------------------------------------
        // コンストラクタ
        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="dictionary">デコレーションするディクショナリーです。</param>
        public InstanceDictionaryDecorator(IDictionary<TKey, TValue> dictionary)
            : base(dictionary)
        {
        }

        //-----------------------------------------------------------------
        // public プロパティ
        //-----------------------------------------------------------------

        /// <summary>
        /// 指定したキーを持つ要素を取得または設定します。
        /// </summary>
        /// <param name="key">取得または設定する要素のキーです。</param>
        /// <returns>指定したキーを持つ要素です。</returns>
        public override TValue this[TKey key]
        {
            set
            {
                Ensure.Argument.NotNull(value);

                base[key] = value;
            }
        }

        //-----------------------------------------------------------------
        // public メソッド
        //-----------------------------------------------------------------

        /// <summary>
        /// 指定したキーおよび値を持つ要素を追加します。
        /// </summary>
        /// <param name="key">追加する要素のキーです。</param>
        /// <param name="value">追加する要素の値です。</param>
        public override void Add(TKey key, TValue value)
        {
            Ensure.Argument.NotNull(value);

            base.Add(key, value);
        }
    }
}
