﻿// ========================================================================
// <copyright file="IMessageProcessor.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using NWCore.Protocols;

namespace NWCore.Viewer
{
    /// <summary>
    /// Interface for message processors.
    /// </summary>
    public interface IMessageProcessor
    {
        /// <summary>
        /// Dispatch received packet to the registered listeners.
        /// </summary>
        /// <param name="header">Packet header</param>
        /// <param name="packet">Packet</param>
        /// <param name="extraPacketData">Extra packet data</param>
        void ProcessMessage(Header header, Protocol4FReader reader);


        /// <summary>
        /// Check if should filter the message.
        /// </summary>
        /// <param name="msgType">The type of the message.</param>
        /// <returns>True to keep the message, false discard it.</returns>
        bool FilterMessage(MessageType msgType);
    }
}
