﻿// ========================================================================
// <copyright file="EmitterSetDataXml.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Collections.Generic;
using System.Xml.Serialization;
using NintendoWare.ToolDevelopmentKit;
using NintendoWare.ToolDevelopmentKit.Conversion;
using NintendoWare.ToolDevelopmentKit.Xml;
using NWCore.DataModel.Major_0.Minor_9.Build_0.Revision_0;

namespace NWCore.Serializer.Major_0.Minor_9.Build_0.Revision_0
{
    /// <summary>
    /// プロジェクトヘッダーのシリアライズ用クラスです
    /// </summary>
    [CoupledType( typeof(EmitterSetData) )]
    [XmlType( "EmitterSet" )]
    public class EmitterSetDataXml
    {
        EmitterSetData m_data;

        #region Construtors

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public EmitterSetDataXml()
        {
            m_data = new EmitterSetData();

            this.EmitterList = new List<ComplexEmitterDataXml>();
        }

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public EmitterSetDataXml( EmitterSetData emitterSet,
                                  IList<EmitterData> emitters,
                                  bool bNormalizeFilePath = true ) :
            this()
        {
            this.m_data.Set( emitterSet );

            foreach ( EmitterData item in emitters )
            {
                this.EmitterList.Add( new ComplexEmitterDataXml( item, bNormalizeFilePath ) );
            }
        }

        /// <summary>
        /// EmitterSetData
        /// </summary>
        public EmitterSetData EmitterSetData
        {
            get { return m_data; }
        }

        #endregion

        #region Properties - EditData

        /// <summary>
        /// 編集用データ
        /// </summary>
        public EditDataEmitterSetXml editor_data
        {
            get { return m_data.EditData.CreateEditDataXml(); }
            set { m_data.EditData.Set(value.EditData); }
        }

        #endregion

        #region Properties

//<name>タグを削除
//         /// <summary>
//         /// アドレス解決後の名前
//         /// </summary>
//         public string name
//         {
//             get { return m_data.Name; }
//             set { m_data.Name = value; }
//         }

        /// <summary>
        /// Binary version
        /// </summary>
        public string Version
        {
            get { return m_data.Version.ToString(); }
            set
            {
                System.Version version;
                if ( System.Version.TryParse( value, out version )==true )
                    m_data.Version = version;
                else
                    m_data.Version = new Version( 0, 9, 0, 0 );
            }
        }

        /// <summary>
        /// ユーザーデータ
        /// </summary>
        public int userData
        {
            get { return (int)m_data.UserData.Data; }
            set { m_data.UserData.Data = (uint)value; }
        }

        /// <summary>
        /// 最終更新日
        /// </summary>
        public int lastUpdateDate
        {
            get { return m_data.LastUpdateDate; }
            set { m_data.LastUpdateDate = value; }
        }

        /// <summary>
        /// 保持しているパーティクルドキュメントのリスト
        /// </summary>
        [XmlArrayItem( "Emitter" )]
        public List<ComplexEmitterDataXml> EmitterList
        {
            get;
            set;
        }

        #endregion

        #region Property for relative file path

        /// <summary>
        /// Normalize path to file name.
        /// </summary>
        protected bool m_bNormalizePath = true;

        /// <summary>
        /// Get or set the flag indicating whether to use relative path or not.
        /// </summary>
        [System.Xml.Serialization.XmlIgnore]
        public bool UseRelativePath
        {
            get { return m_bNormalizePath; }
            set
            {
                m_bNormalizePath = value;
                foreach ( ComplexEmitterDataXml item in this.EmitterList )
                {
                    item.UseRelativePath = value;
                }
            }
        }

        #endregion

    }
}
