﻿// ========================================================================
// <copyright file="MessageTypeAttribute.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.IO;
using System.Text;

namespace NWCore.Protocols
{
    /// <summary>
    /// MessageTypeAttribute
    /// </summary>
    [AttributeUsage(AttributeTargets.Field, AllowMultiple=false, Inherited=false)]
    public class MessageTypeAttribute : Attribute
    {
        private Type _messageTypeType;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public MessageTypeAttribute(Type messageTypeType)
        {
            _messageTypeType = messageTypeType;
        }

        /// <summary>
        /// CreateMessagePacket
        /// </summary>
        public static BaseMessagePacket CreateMessagePacket(MessageType messageType)
        {
            Type enumType = messageType.GetType();

            string name = Enum.GetName(enumType, messageType);

            MessageTypeAttribute[] attrs =
                (MessageTypeAttribute[])enumType.GetField(name).GetCustomAttributes(
                    typeof(MessageTypeAttribute), false);

            return (BaseMessagePacket)Activator.CreateInstance(attrs[0]._messageTypeType);
        }
    }
}
