﻿// ========================================================================
// <copyright file="IDocument.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Windows.Forms;
using NintendoWare.ToolDevelopmentKit;
using NWCore.DataModel;

namespace NWCore.DataModel
{
    /// <summary>
    /// ドキュメント用のインターフェイスです。
    /// </summary>
    public interface IDocument : INamedObject
    {
        string Comment { get; set; }
        System.Drawing.Image DocumentIcon { get; }
        System.Drawing.Image DocumentIconImage { get; }

        GuiObjectID ObjectID { get; }
        string ImageKey { get; }
        bool FileExists { get; }
        string FileExt { get; }
        string FileFilter { get; }
        string FileLocation { get; }
        string FileName { get; }
        string FilePath { get; }
        string FileTitle { get; set; }
        string BinaryFileExt { get; }
        string BinaryFileFilter { get; }
        string BinaryFileName { get; }

        string RelativeDataScrPath { get; }
        string DataScrPath { get; }
        string DisplayDataPath { get; }

        bool Enable { get; set; }
        bool IsSymbolColorEnabled { get; }
        bool Modified { get; }
        bool HasUnreachableAsset { get; }
        IDocument OwnerDocument { get; }
        Image ObjectIcon { get; }
        IDocument FindChild(string name);

        /// <summary>
        /// サブ・ドキュメントを取得します。
        /// </summary>
        IEnumerable<IDocument> SubDocuments { get; }

        int Count { get; }

        void SetModified( bool bUpdateProjectTree = true );
        void UndoModify( bool bUpdateProjectTree = true );
        int ClearModifiedFlag( bool bUpdateProjectTree = true );

        void ClearFileLocation();
        bool SaveBinary(FileStream writer, bool isOptimize);

        bool SaveDocumentToStream( Stream stream,
                                   bool bClearModifyFlag = true,
                                   bool bNormalizePath = true );

        bool SaveDocument( string filePath,
                           bool bClearModifyFlag = true,
                           bool bNormalizePath = true );

        void SetFileLocation(string fileLocation);
        void UpdateDocument();

        void NotifyAddedToParent();
        void NotifyRemovedFromParent();
    }
}
