﻿// ========================================================================
// <copyright file="FluctuationFlag.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel
{
    /// <summary>
    /// child flag
    /// </summary>
    public class FluctuationFlag : ISettable
    {
        /// <summary>
        /// Get or set the flags.
        /// </summary>
        public uint Flag
        {
            get
            {
                uint ret = 0;

                if (Enable) ret |= (1 << 0);
                if (ApplyAlpha) ret |= (1 << 1);
                if (ApplyScale) ret |= (1 << 2);

                return ret;
            }
            set
            {
                Enable = (0 != (value & (1 << 0)));
                ApplyAlpha = (0 != (value & (1 << 1)));
                ApplyScale = (0 != (value & (1 << 2)));
            }
        }

        /// <summary>
        /// ISettable用
        /// </summaey>
        public void Set(object source)
        {
            Ensure.Argument.True(source is FluctuationFlag);
            this.Flag = (source as FluctuationFlag).Flag;
        }

        /// <summary>
        /// 揺らぎを使用するか？
        /// </summary>
        public bool Enable { get; set; }

        /// <summary>
        /// αに適応するか？
        /// </summary>
        public bool ApplyAlpha { get; set; }

        /// <summary>
        /// スケールに適応するか？
        /// </summary>
        public bool ApplyScale { get; set; }
    }
}
